/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import java.util.Optional;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.string.UTF8;

public class SupportedCommunityVersion
extends KnownCommunitySecurityComponentVersion {
    private final UserRepository userRepository;
    private SecureHasher secureHasher;

    SupportedCommunityVersion(int version, String description, Log log, UserRepository userRepository) {
        super(version, description, log);
        this.userRepository = userRepository;
        this.secureHasher = new SecureHasher();
    }

    @Override
    public boolean migrationSupported() {
        return true;
    }

    @Override
    public boolean runtimeSupported() {
        return true;
    }

    @Override
    public void upgradeSecurityGraph(Transaction tx, KnownCommunitySecurityComponentVersion latest) {
        assert (latest.version == 2);
        this.setVersionProperty(tx, latest.version);
    }

    @Override
    public void setupUsers(Transaction tx) throws Exception {
        this.addDefaultUser(tx);
    }

    private void addDefaultUser(Transaction tx) throws Exception {
        Optional<User> initialUser = this.getInitialUser();
        if (initialUser.isPresent()) {
            User user = initialUser.get();
            this.log.info(String.format("Setting up initial user from `auth.ini` file: %s", user.name()));
            this.addUser(tx, "neo4j", user.credentials(), user.passwordChangeRequired(), user.hasFlag("is_suspended"));
        } else {
            SystemGraphCredential credential = SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"neo4j"), (SecureHasher)this.secureHasher);
            this.log.info(String.format("Setting up initial user from defaults: %s", "neo4j"));
            this.addUser(tx, "neo4j", (Credential)credential, true, false);
        }
    }

    @Override
    public Optional<Exception> updateInitialUserPassword(Transaction tx) {
        try {
            Optional<User> initialUser = this.getInitialUser();
            if (initialUser.isPresent()) {
                this.updateInitialUserPassword(tx, initialUser.get());
            } else {
                this.log.debug("Not updating initial user password: No initial user found in `auth.ini`");
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private Optional<User> getInitialUser() throws Exception {
        this.userRepository.start();
        this.log.debug("Opened `auth.ini` file to find the initial user");
        if (this.userRepository.numberOfUsers() == 0) {
            this.log.debug("Not updating initial user password: No initial user found in `auth.ini`");
        }
        if (this.userRepository.numberOfUsers() == 1) {
            User initialUser = this.userRepository.getUserByName("neo4j");
            if (initialUser == null) {
                String errorMessage = "Invalid `auth.ini` file: the user in the file is not named neo4j";
                this.log.error(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            this.log.debug("Valid `auth.ini` file: found initial user");
            return Optional.of(initialUser);
        }
        if (this.userRepository.numberOfUsers() > 1) {
            String errorMessage = "Invalid `auth.ini` file: the file contains more than one user";
            this.log.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        return Optional.empty();
    }
}

