/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.KnownSystemComponentVersions;
import org.neo4j.server.security.systemgraph.versions.CommunityVersion_0_35;
import org.neo4j.server.security.systemgraph.versions.CommunityVersion_1_40;
import org.neo4j.server.security.systemgraph.versions.CommunityVersion_2_41;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.server.security.systemgraph.versions.NoUserSecurityGraph;

public class UserSecurityGraphComponent
extends AbstractSystemGraphComponent {
    public static final String COMPONENT = "security-users";
    private final KnownSystemComponentVersions<KnownCommunitySecurityComponentVersion> knownUserSecurityComponentVersions = new KnownSystemComponentVersions<NoUserSecurityGraph>(new NoUserSecurityGraph());
    private final Log log;

    public UserSecurityGraphComponent(Log log, UserRepository userRepository, UserRepository initialPasswordRepo, Config config) {
        super(config);
        this.log = log;
        this.knownUserSecurityComponentVersions.add(new CommunityVersion_0_35(log, userRepository));
        this.knownUserSecurityComponentVersions.add(new CommunityVersion_1_40(log, initialPasswordRepo));
        this.knownUserSecurityComponentVersions.add(new CommunityVersion_2_41(log, initialPasswordRepo));
    }

    public String component() {
        return COMPONENT;
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return this.knownUserSecurityComponentVersions.detectCurrentSecurityGraphVersion(tx).getStatus();
    }

    public void initializeSystemGraphModel(Transaction tx) throws Exception {
        KnownCommunitySecurityComponentVersion componentBeforeInit = this.knownUserSecurityComponentVersions.detectCurrentSecurityGraphVersion(tx);
        this.log.info("Initializing system graph model for component '%s' with version %d and status %s", new Object[]{COMPONENT, componentBeforeInit.version, componentBeforeInit.getStatus()});
        this.initializeLatestSystemGraph(tx);
        KnownCommunitySecurityComponentVersion componentAfterInit = this.knownUserSecurityComponentVersions.detectCurrentSecurityGraphVersion(tx);
        this.log.info("After initialization of system graph model component '%s' have version %d and status %s", new Object[]{COMPONENT, componentAfterInit.version, componentAfterInit.getStatus()});
    }

    public void initializeSystemGraphConstraints(Transaction tx) {
        this.initializeSystemGraphConstraint(tx, KnownCommunitySecurityComponentVersion.USER_LABEL, "name");
    }

    private void initializeLatestSystemGraph(Transaction tx) throws Exception {
        KnownCommunitySecurityComponentVersion latest = this.knownUserSecurityComponentVersions.latestSecurityGraphVersion();
        this.log.debug("Latest version of component '%s' is %s", new Object[]{COMPONENT, latest.version});
        latest.setupUsers(tx);
        latest.setVersionProperty(tx, latest.version);
    }

    protected void postInitialization(GraphDatabaseService system, boolean wasInitialized) throws Exception {
        try (Transaction tx = system.beginTx();){
            KnownCommunitySecurityComponentVersion component = this.knownUserSecurityComponentVersions.detectCurrentSecurityGraphVersion(tx);
            this.log.info("Performing postInitialization step for component '%s' with version %d and status %s", new Object[]{COMPONENT, component.version, component.getStatus()});
            if (!wasInitialized) {
                this.log.info("Updating the initial password in component '%s'  ", new Object[]{COMPONENT, component.version, component.getStatus()});
                Optional<Exception> exception = component.updateInitialUserPassword(tx);
                tx.commit();
                if (exception.isPresent()) {
                    throw exception.get();
                }
            }
        }
    }

    public Optional<Exception> upgradeToCurrent(GraphDatabaseService system) {
        return SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, tx -> {
            KnownCommunitySecurityComponentVersion currentVersion = this.knownUserSecurityComponentVersions.detectCurrentSecurityGraphVersion((Transaction)tx);
            this.log.debug("Trying to upgrade component '%s' with version %d and status %s to latest version", new Object[]{COMPONENT, currentVersion.version, currentVersion.getStatus()});
            if (currentVersion.version == -1) {
                this.log.debug("The current version does not have a security graph, doing a full initialization");
                this.initializeLatestSystemGraph((Transaction)tx);
            } else if (currentVersion.migrationSupported()) {
                this.log.info("Upgrading security graph to latest version");
                currentVersion.upgradeSecurityGraph((Transaction)tx, this.knownUserSecurityComponentVersions.latestSecurityGraphVersion());
            } else {
                throw currentVersion.unsupported();
            }
        });
    }
}

