/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.security.User;

public class BasicLoginContext
extends LoginContext {
    private AccessMode accessMode;

    public BasicLoginContext(User user, AuthenticationResult authenticationResult, ClientConnectionInfo connectionInfo) {
        super((AuthSubject)new BasicAuthSubject(user, authenticationResult), connectionInfo);
        switch (authenticationResult) {
            case SUCCESS: {
                this.accessMode = AccessMode.Static.FULL;
                break;
            }
            case PASSWORD_CHANGE_REQUIRED: {
                this.accessMode = AccessMode.Static.CREDENTIALS_EXPIRED;
                break;
            }
            default: {
                this.accessMode = AccessMode.Static.ACCESS;
            }
        }
    }

    public SecurityContext authorize(LoginContext.IdLookup idLookup, String dbName, AbstractSecurityLog securityLog) {
        SecurityContext securityContext = new SecurityContext(this.subject(), this.accessMode, this.connectionInfo(), dbName);
        if (this.subject().getAuthenticationResult().equals((Object)AuthenticationResult.FAILURE) || this.subject().getAuthenticationResult().equals((Object)AuthenticationResult.TOO_MANY_ATTEMPTS)) {
            securityLog.error(securityContext, String.format("Authentication failed for database '%s'.", dbName));
            throw new AuthorizationViolationException("Permission denied.", (Status)Status.Security.Unauthorized);
        }
        if (!dbName.equals("system") && this.subject().getAuthenticationResult().equals((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED)) {
            String message = SecurityAuthorizationHandler.generateCredentialsExpiredMessage((String)String.format("ACCESS on database '%s' is not allowed.", dbName));
            securityLog.error(securityContext, message);
            throw new AuthorizationViolationException(message, (Status)Status.Security.CredentialsExpired);
        }
        return securityContext;
    }

    private static class BasicAuthSubject
    implements AuthSubject {
        private User user;
        private AuthenticationResult authenticationResult;

        BasicAuthSubject(User user, AuthenticationResult authenticationResult) {
            this.user = user;
            this.authenticationResult = authenticationResult;
        }

        public AuthenticationResult getAuthenticationResult() {
            return this.authenticationResult;
        }

        public String username() {
            if (this.user != null) {
                return this.user.name();
            }
            return "";
        }

        public boolean hasUsername(String username) {
            return this.username().equals(username);
        }
    }
}

