/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.Map;
import org.neo4j.cypher.internal.security.FormatException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicLoginContext;
import org.neo4j.server.security.systemgraph.SystemGraphRealmHelper;

public class BasicSystemGraphRealm
extends AuthManager {
    private final SystemGraphRealmHelper systemGraphRealmHelper;
    private final AuthenticationStrategy authenticationStrategy;

    public BasicSystemGraphRealm(SystemGraphRealmHelper systemGraphRealmHelper, AuthenticationStrategy authenticationStrategy) {
        this.systemGraphRealmHelper = systemGraphRealmHelper;
        this.authenticationStrategy = authenticationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginContext login(Map<String, Object> authToken, ClientConnectionInfo connectionInfo) throws InvalidAuthTokenException {
        try {
            BasicSystemGraphRealm.assertValidScheme(authToken);
            String username = AuthToken.safeCast((String)"principal", authToken);
            byte[] password = AuthToken.safeCastCredentials((String)"credentials", authToken);
            try {
                User user = this.systemGraphRealmHelper.getUser(username);
                AuthenticationResult result = this.authenticationStrategy.authenticate(user, password);
                if (result == AuthenticationResult.SUCCESS && user.passwordChangeRequired()) {
                    result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
                }
                BasicLoginContext basicLoginContext = new BasicLoginContext(user, result, connectionInfo);
                return basicLoginContext;
            }
            catch (FormatException | InvalidArgumentsException e) {
                BasicLoginContext basicLoginContext = new BasicLoginContext(null, AuthenticationResult.FAILURE, connectionInfo);
                AuthToken.clearCredentials(authToken);
                return basicLoginContext;
            }
        }
        finally {
            AuthToken.clearCredentials(authToken);
        }
    }

    public void log(String message, SecurityContext securityContext) {
    }

    private static void assertValidScheme(Map<String, Object> token) throws InvalidAuthTokenException {
        String scheme = AuthToken.safeCast((String)"scheme", token);
        if (scheme.equals("none")) {
            throw AuthToken.invalidToken((String)", scheme 'none' is only allowed when auth is disabled.");
        }
        if (!scheme.equals("basic")) {
            throw AuthToken.invalidToken((String)(", scheme '" + scheme + "' is not supported."));
        }
    }
}

