/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.string.HexString;
import org.neo4j.string.UTF8;

public class LegacyCredential
implements Credential {
    static final String DIGEST_ALGO = "SHA-256";
    static final int ITERATIONS = 1;
    public static final LegacyCredential INACCESSIBLE = new LegacyCredential(new byte[0], new byte[0]);
    private static final SecureRandom random = new SecureRandom();
    private final byte[] salt;
    private final byte[] passwordHash;

    public static LegacyCredential forPassword(byte[] password) {
        byte[] salt = LegacyCredential.randomSalt();
        return new LegacyCredential(salt, LegacyCredential.hash(salt, password));
    }

    public static LegacyCredential forPassword(String password) {
        return LegacyCredential.forPassword(UTF8.encode((String)password));
    }

    public LegacyCredential(byte[] salt, byte[] passwordHash) {
        this.salt = salt;
        this.passwordHash = passwordHash;
    }

    public byte[] salt() {
        return this.salt;
    }

    public byte[] passwordHash() {
        return this.passwordHash;
    }

    public boolean matchesPassword(byte[] password) {
        return LegacyCredential.byteEquals(this.passwordHash, LegacyCredential.hash(this.salt, password));
    }

    public boolean matchesPassword(String password) {
        return LegacyCredential.byteEquals(this.passwordHash, LegacyCredential.hash(this.salt, UTF8.encode((String)password)));
    }

    public String serialize() {
        String encodedSalt = HexString.encodeHexString((byte[])this.salt());
        String encodedPassword = HexString.encodeHexString((byte[])this.passwordHash());
        return String.join((CharSequence)",", DIGEST_ALGO, encodedPassword, encodedSalt, String.valueOf(1));
    }

    private static boolean byteEquals(byte[] actual, byte[] given) {
        if (actual == given) {
            return true;
        }
        if (actual == null || given == null) {
            return false;
        }
        int actualLength = actual.length;
        int givenLength = given.length;
        boolean result = true;
        for (int i = 0; i < givenLength; ++i) {
            if (actualLength <= 0) continue;
            result &= actual[i % actualLength] == given[i];
        }
        return result && actualLength == givenLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyCredential that = (LegacyCredential)o;
        boolean saltEquals = LegacyCredential.byteEquals(this.salt, that.salt);
        boolean passwordEquals = LegacyCredential.byteEquals(this.passwordHash, that.passwordHash);
        return saltEquals && passwordEquals;
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.salt) + Arrays.hashCode(this.passwordHash);
    }

    public String toString() {
        return "Credential{salt=0x" + HexString.encodeHexString((byte[])this.salt) + ", passwordHash=0x" + HexString.encodeHexString((byte[])this.passwordHash) + "}";
    }

    private static byte[] hash(byte[] salt, byte[] password) {
        try {
            MessageDigest m = MessageDigest.getInstance(DIGEST_ALGO);
            m.update(salt, 0, salt.length);
            m.update(password, 0, password.length);
            return m.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hash algorithm is not available on this platform: " + e.getMessage(), e);
        }
    }

    private static byte[] randomSalt() {
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        return salt;
    }
}

