/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersions;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponentWithVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.versions.CommunitySecurityComponentVersion_1_40;
import org.neo4j.server.security.systemgraph.versions.CommunitySecurityComponentVersion_2_41;
import org.neo4j.server.security.systemgraph.versions.CommunitySecurityComponentVersion_3_43D4;
import org.neo4j.server.security.systemgraph.versions.CommunitySecurityComponentVersion_4_50;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.server.security.systemgraph.versions.NoCommunitySecurityComponentVersion;
import org.neo4j.util.VisibleForTesting;

public class UserSecurityGraphComponent
extends AbstractSystemGraphComponent
implements SystemGraphComponentWithVersion {
    private final KnownSystemComponentVersions<KnownCommunitySecurityComponentVersion> knownUserSecurityComponentVersions = new KnownSystemComponentVersions((KnownSystemComponentVersion)new NoCommunitySecurityComponentVersion());
    private final Log debugLog;

    public UserSecurityGraphComponent(UserRepository initialPasswordRepo, Config config, LogProvider debugLogProvider, AbstractSecurityLog securityLog) {
        super(config);
        this.debugLog = debugLogProvider.getLog(UserSecurityGraphComponent.class);
        CommunitySecurityComponentVersion_1_40 version1 = new CommunitySecurityComponentVersion_1_40(this.debugLog, securityLog, initialPasswordRepo);
        CommunitySecurityComponentVersion_2_41 version2 = new CommunitySecurityComponentVersion_2_41(this.debugLog, securityLog, initialPasswordRepo, version1);
        CommunitySecurityComponentVersion_3_43D4 version3 = new CommunitySecurityComponentVersion_3_43D4(this.debugLog, securityLog, initialPasswordRepo, version2);
        CommunitySecurityComponentVersion_4_50 version4 = new CommunitySecurityComponentVersion_4_50(this.debugLog, securityLog, initialPasswordRepo, version3);
        this.knownUserSecurityComponentVersions.add((KnownSystemComponentVersion)version1);
        this.knownUserSecurityComponentVersions.add((KnownSystemComponentVersion)version2);
        this.knownUserSecurityComponentVersions.add((KnownSystemComponentVersion)version3);
        this.knownUserSecurityComponentVersions.add((KnownSystemComponentVersion)version4);
    }

    public SystemGraphComponent.Name componentName() {
        return ComponentVersion.SECURITY_USER_COMPONENT;
    }

    public int getLatestSupportedVersion() {
        return ((KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.latestComponentVersion()).binaryVersion();
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return ((KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.detectCurrentComponentVersion(tx)).getStatus(this.config);
    }

    public void initializeSystemGraphModel(Transaction tx, GraphDatabaseService systemDb) throws Exception {
        KnownCommunitySecurityComponentVersion componentBeforeInit = (KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.detectCurrentComponentVersion(tx);
        this.debugLog.info(String.format("Initializing system graph model for component '%s' with version %d and status %s", ComponentVersion.SECURITY_USER_COMPONENT, componentBeforeInit.version, componentBeforeInit.getStatus(this.config)));
        this.initializeLatestSystemGraph(tx);
        KnownCommunitySecurityComponentVersion componentAfterInit = (KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.detectCurrentComponentVersion(tx);
        this.debugLog.info(String.format("After initialization of system graph model component '%s' have version %d and status %s", ComponentVersion.SECURITY_USER_COMPONENT, componentAfterInit.version, componentAfterInit.getStatus(this.config)));
    }

    public void initializeSystemGraphConstraints(Transaction tx) {
        UserSecurityGraphComponent.initializeSystemGraphConstraint((Transaction)tx, (Label)KnownCommunitySecurityComponentVersion.USER_LABEL, (String[])new String[]{"name"});
        UserSecurityGraphComponent.initializeSystemGraphConstraint((Transaction)tx, (Label)KnownCommunitySecurityComponentVersion.USER_LABEL, (String[])new String[]{"id"});
    }

    private void initializeLatestSystemGraph(Transaction tx) throws Exception {
        KnownCommunitySecurityComponentVersion latest = (KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.latestComponentVersion();
        this.debugLog.debug(String.format("Latest version of component '%s' is %s", ComponentVersion.SECURITY_USER_COMPONENT, latest.version));
        latest.setupUsers(tx);
        latest.setVersionProperty(tx, latest.version);
    }

    @VisibleForTesting
    public void postInitialization(GraphDatabaseService system, boolean wasInitialized) throws Exception {
        try (Transaction tx = system.beginTx();){
            KnownCommunitySecurityComponentVersion component = (KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.detectCurrentComponentVersion(tx);
            this.debugLog.info(String.format("Performing postInitialization step for component '%s' with version %d and status %s", ComponentVersion.SECURITY_USER_COMPONENT, component.version, component.getStatus(this.config)));
            if (!wasInitialized) {
                this.debugLog.info(String.format("Updating the initial password in component '%s'", ComponentVersion.SECURITY_USER_COMPONENT));
                component.updateInitialUserPassword(tx);
                tx.commit();
            }
        }
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        KnownCommunitySecurityComponentVersion currentVersion;
        try (TransactionImpl tx2 = (TransactionImpl)system.beginTx();
             KernelTransaction.Revertable ignore = tx2.kernelTransaction().overrideWith(SecurityContext.AUTH_DISABLED);){
            currentVersion = (KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.detectCurrentComponentVersion((Transaction)tx2);
            tx2.commit();
        }
        this.debugLog.debug(String.format("Trying to upgrade component '%s' with version %d and status %s to latest version", ComponentVersion.SECURITY_USER_COMPONENT, currentVersion.version, currentVersion.getStatus(this.config)));
        if (currentVersion.version == -1) {
            this.debugLog.debug("The current version does not have a security graph, doing a full initialization");
            SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, this::initializeLatestSystemGraph);
            SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, this::initializeSystemGraphConstraints);
        } else if (currentVersion.migrationSupported()) {
            this.debugLog.info("Upgrading security graph to latest version");
            SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, tx -> ((KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.latestComponentVersion()).upgradeSecurityGraph((Transaction)tx, currentVersion.version));
            SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, tx -> ((KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.latestComponentVersion()).upgradeSecurityGraphSchema((Transaction)tx, currentVersion.version));
        } else {
            throw currentVersion.unsupported();
        }
    }

    public KnownCommunitySecurityComponentVersion findSecurityGraphComponentVersion(ComponentVersion version) {
        return (KnownCommunitySecurityComponentVersion)this.knownUserSecurityComponentVersions.findComponentVersion(version);
    }
}

