/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.lang.util.ByteSource;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.auth.Neo4jPrincipal;

public class ShiroAuthenticationInfo
extends SimpleAuthenticationInfo {
    protected AuthenticationResult authenticationResult;
    private List<Throwable> throwables;
    private static final AuthenticationResult[][] MERGE_MATRIX = new AuthenticationResult[][]{{AuthenticationResult.SUCCESS, AuthenticationResult.SUCCESS, AuthenticationResult.SUCCESS, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}, {AuthenticationResult.SUCCESS, AuthenticationResult.FAILURE, AuthenticationResult.TOO_MANY_ATTEMPTS, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}, {AuthenticationResult.SUCCESS, AuthenticationResult.TOO_MANY_ATTEMPTS, AuthenticationResult.TOO_MANY_ATTEMPTS, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}, {AuthenticationResult.PASSWORD_CHANGE_REQUIRED, AuthenticationResult.PASSWORD_CHANGE_REQUIRED, AuthenticationResult.PASSWORD_CHANGE_REQUIRED, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}};

    public ShiroAuthenticationInfo() {
        this.authenticationResult = AuthenticationResult.FAILURE;
        this.throwables = new ArrayList<Throwable>(1);
    }

    public ShiroAuthenticationInfo(Neo4jPrincipal principal, String realmName, AuthenticationResult authenticationResult) {
        super((Object)principal, null, realmName);
        this.authenticationResult = authenticationResult;
    }

    public ShiroAuthenticationInfo(Neo4jPrincipal principal, Object hashedCredentials, ByteSource credentialsSalt, String realmName, AuthenticationResult authenticationResult) {
        super((Object)principal, hashedCredentials, credentialsSalt, realmName);
        this.authenticationResult = authenticationResult;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public void setAuthenticationResult(AuthenticationResult result) {
        this.authenticationResult = result;
    }

    public void addThrowable(Throwable t) {
        this.throwables.add(t);
    }

    public List<Throwable> getThrowables() {
        return this.throwables;
    }

    public void merge(AuthenticationInfo info) {
        if (info == null || info.getPrincipals() == null || info.getPrincipals().isEmpty()) {
            return;
        }
        super.merge(info);
        this.authenticationResult = info instanceof ShiroAuthenticationInfo ? ShiroAuthenticationInfo.mergeAuthenticationResult(this.authenticationResult, ((ShiroAuthenticationInfo)info).getAuthenticationResult()) : ShiroAuthenticationInfo.mergeAuthenticationResult(this.authenticationResult, AuthenticationResult.SUCCESS);
    }

    private static AuthenticationResult mergeAuthenticationResult(AuthenticationResult result, AuthenticationResult newResult) {
        return MERGE_MATRIX[result.ordinal()][newResult.ordinal()];
    }
}

