/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.Log;
import org.neo4j.server.security.FormatException;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SystemGraphCredential;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponentVersion;
import org.neo4j.string.UTF8;

public abstract class KnownCommunitySecurityComponentVersion
extends KnownSystemComponentVersion {
    public static final Label USER_LABEL = Label.label((String)"User");
    public static final String USER_ID = "id";
    public static final String USER_NAME = "name";
    public static final String USER_CREDENTIALS = "credentials";
    public static final String USER_EXPIRED = "passwordChangeRequired";
    public static final String USER_SUSPENDED = "suspended";
    public static final String USER_HOME_DB = "homeDatabase";
    public static final String AUTH_CONSTRAINT = "auth-constraint";
    public static final Label AUTH_LABEL = Label.label((String)"Auth");
    public static final String AUTH_PROVIDER = "provider";
    public static final String AUTH_ID = "id";
    public static final RelationshipType HAS_AUTH = RelationshipType.withName((String)"HAS_AUTH");
    private final SecureHasher secureHasher = new SecureHasher();
    private final AbstractSecurityLog securityLog;

    KnownCommunitySecurityComponentVersion(ComponentVersion componentVersion, Log debugLog, AbstractSecurityLog securityLog) {
        super(componentVersion, debugLog);
        this.securityLog = securityLog;
    }

    public abstract void setupUsers(Transaction var1) throws Exception;

    public void addUser(Transaction tx, String username, Credential credentials, boolean passwordChangeRequired, boolean suspended) {
        this.securityLog.info(String.format("CREATE USER %s PASSWORD ****** CHANGE %s%s", username, passwordChangeRequired ? "REQUIRED" : "NOT REQUIRED", suspended ? " SET STATUS SUSPENDED" : ""));
        Node node = tx.createNode(new Label[]{USER_LABEL});
        node.setProperty(USER_NAME, (Object)username);
        node.setProperty(USER_CREDENTIALS, (Object)credentials.serialize());
        node.setProperty(USER_EXPIRED, (Object)passwordChangeRequired);
        node.setProperty(USER_SUSPENDED, (Object)suspended);
        node.setProperty("id", (Object)UUID.randomUUID().toString());
        if (this.version >= UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_521.getVersion()) {
            this.addAuthObject(tx, node);
        }
    }

    public abstract void updateInitialUserPassword(Transaction var1) throws Exception;

    void updateInitialUserPassword(Transaction tx, User initialUser) throws FormatException {
        List users = Iterators.asList((Iterator)tx.findNodes(USER_LABEL));
        if (users.isEmpty()) {
            this.debugLog.warn(String.format("Unable to update missing initial user password from `auth.ini` file: %s", initialUser.name()));
        } else if (users.size() == 1) {
            SystemGraphCredential currentCredentials;
            Node user = (Node)users.get(0);
            if (user.getProperty(USER_NAME).equals("neo4j") && (currentCredentials = SystemGraphCredential.deserialize(user.getProperty(USER_CREDENTIALS).toString(), this.secureHasher)).matchesPassword(UTF8.encode((String)"neo4j"))) {
                this.debugLog.info(String.format("Updating initial user password from `auth.ini` file: %s", initialUser.name()));
                user.setProperty(USER_CREDENTIALS, (Object)initialUser.credential().value().serialize());
                user.setProperty(USER_EXPIRED, (Object)initialUser.passwordChangeRequired());
            }
        } else {
            this.debugLog.warn("Unable to update initial user password from `auth.ini` file: multiple users in the DBMS");
        }
    }

    public void addAuthObjects(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(USER_LABEL);){
            while (nodes.hasNext()) {
                Node user = (Node)nodes.next();
                if (!user.hasProperty(USER_CREDENTIALS) || user.hasRelationship(new RelationshipType[]{HAS_AUTH})) continue;
                this.addAuthObject(tx, user);
            }
        }
    }

    private void addAuthObject(Transaction tx, Node user) {
        String userId = (String)user.getProperty("id");
        Node authNode = tx.createNode(new Label[]{AUTH_LABEL});
        authNode.setProperty(AUTH_PROVIDER, (Object)"native");
        authNode.setProperty("id", (Object)userId);
        user.createRelationshipTo(authNode, HAS_AUTH);
    }

    public abstract void upgradeSecurityGraph(Transaction var1, int var2) throws Exception;

    public abstract void upgradeSecurityGraphSchema(Transaction var1, int var2) throws Exception;

    public boolean requiresAuthObject() {
        return true;
    }
}

