/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import java.util.EnumMap;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;

public class HilbertSpaceFillingCurve2D
extends SpaceFillingCurve {
    private static final EnumMap<Direction2D, HilbertCurve2D> CURVES = new EnumMap(Direction2D.class);
    private static final HilbertCurve2D curveUp;
    public static final int MAX_LEVEL = 30;

    private static void addCurveRule(int ... npointValues) {
        HilbertCurve2D curve = new HilbertCurve2D(npointValues);
        Direction2D name = curve.name();
        if (!CURVES.containsKey((Object)name)) {
            CURVES.put(name, curve);
        }
    }

    private static void setChildren(Direction2D parent, Direction2D ... children) {
        HilbertCurve2D curve = CURVES.get((Object)parent);
        SpaceFillingCurve.CurveRule[] childCurves = new HilbertCurve2D[children.length];
        for (int i = 0; i < children.length; ++i) {
            childCurves[i] = CURVES.get((Object)children[i]);
        }
        curve.setChildren(childCurves);
    }

    public HilbertSpaceFillingCurve2D(Envelope range) {
        this(range, 30);
    }

    public HilbertSpaceFillingCurve2D(Envelope range, int maxLevel) {
        super(range, maxLevel);
        assert (maxLevel <= 30);
        assert (range.getDimension() == 2);
    }

    @Override
    protected SpaceFillingCurve.CurveRule rootCurve() {
        return curveUp;
    }

    static {
        HilbertSpaceFillingCurve2D.addCurveRule(0, 1, 3, 2);
        HilbertSpaceFillingCurve2D.addCurveRule(0, 2, 3, 1);
        HilbertSpaceFillingCurve2D.addCurveRule(3, 1, 0, 2);
        HilbertSpaceFillingCurve2D.addCurveRule(3, 2, 0, 1);
        HilbertSpaceFillingCurve2D.setChildren(Direction2D.UP, Direction2D.RIGHT, Direction2D.UP, Direction2D.UP, Direction2D.LEFT);
        HilbertSpaceFillingCurve2D.setChildren(Direction2D.RIGHT, Direction2D.UP, Direction2D.RIGHT, Direction2D.RIGHT, Direction2D.DOWN);
        HilbertSpaceFillingCurve2D.setChildren(Direction2D.DOWN, Direction2D.LEFT, Direction2D.DOWN, Direction2D.DOWN, Direction2D.RIGHT);
        HilbertSpaceFillingCurve2D.setChildren(Direction2D.LEFT, Direction2D.DOWN, Direction2D.LEFT, Direction2D.LEFT, Direction2D.UP);
        curveUp = CURVES.get((Object)Direction2D.UP);
    }

    static enum Direction2D {
        UP,
        RIGHT,
        LEFT,
        DOWN;

    }

    static class HilbertCurve2D
    extends SpaceFillingCurve.CurveRule {
        private SpaceFillingCurve.CurveRule[] children;

        private HilbertCurve2D(int ... npointValues) {
            super(2, npointValues);
            assert (npointValues[0] == 0 || npointValues[0] == 3);
        }

        private Direction2D direction(int end) {
            int start = this.npointValues[0];
            switch (end -= start) {
                case 1: {
                    return Direction2D.UP;
                }
                case 2: {
                    return Direction2D.RIGHT;
                }
                case -2: {
                    return Direction2D.LEFT;
                }
                case -1: {
                    return Direction2D.DOWN;
                }
            }
            throw new IllegalArgumentException("Illegal direction: " + end);
        }

        private Direction2D name() {
            return this.direction(this.npointValues[1]);
        }

        private void setChildren(SpaceFillingCurve.CurveRule ... children) {
            this.children = children;
        }

        @Override
        public SpaceFillingCurve.CurveRule childAt(int npoint) {
            return this.children[npoint];
        }

        public String toString() {
            return String.valueOf((Object)this.name());
        }
    }
}

