/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;

public class HilbertSpaceFillingCurve3D
extends SpaceFillingCurve {
    private static final Map<SubCurve3D, HilbertCurve3D> CURVES = new LinkedHashMap<SubCurve3D, HilbertCurve3D>();
    private static final HilbertCurve3D THE_CURVE = HilbertSpaceFillingCurve3D.buildTheCurve();
    public static final int MAX_LEVEL = 20;

    private static HilbertCurve3D buildTheCurve() {
        int[] npointValues = new int[]{0, 2, 3, 1, 5, 7, 6, 4};
        HilbertCurve3D theCurve = new HilbertCurve3D(npointValues);
        theCurve.buildCurveTree(CURVES);
        return theCurve;
    }

    HilbertSpaceFillingCurve3D(Envelope range) {
        this(range, 20);
    }

    public HilbertSpaceFillingCurve3D(Envelope range, int maxLevel) {
        super(range, maxLevel);
        assert (maxLevel <= 20);
        assert (range.getDimension() == 3);
    }

    @Override
    protected SpaceFillingCurve.CurveRule rootCurve() {
        return THE_CURVE;
    }

    static class HilbertCurve3D
    extends SpaceFillingCurve.CurveRule {
        HilbertCurve3D[] children;

        private HilbertCurve3D(int ... npointValues) {
            super(3, npointValues);
            assert (npointValues[0] == 0 || npointValues[0] == 3 || npointValues[0] == 5 || npointValues[0] == 6);
        }

        @Override
        public SpaceFillingCurve.CurveRule childAt(int npoint) {
            return this.children[npoint];
        }

        public String toString() {
            return this.name().toString();
        }

        private static Direction3D direction(int start, int end) {
            switch (end -= start) {
                case 1: {
                    return Direction3D.FRONT;
                }
                case 2: {
                    return Direction3D.UP;
                }
                case 4: {
                    return Direction3D.RIGHT;
                }
                case -4: {
                    return Direction3D.LEFT;
                }
                case -2: {
                    return Direction3D.DOWN;
                }
                case -1: {
                    return Direction3D.BACK;
                }
            }
            throw new IllegalArgumentException("Illegal direction: " + end);
        }

        SubCurve3D name() {
            return new SubCurve3D(HilbertCurve3D.direction(this.npointValues[0], this.npointValues[1]), HilbertCurve3D.direction(this.npointValues[1], this.npointValues[2]), HilbertCurve3D.direction(this.npointValues[0], this.npointValues[this.length() - 1]));
        }

        private HilbertCurve3D rotateOneThirdDiagonalPos(boolean direction) {
            int[] newNpoints = new int[this.length()];
            for (int i = 0; i < this.length(); ++i) {
                newNpoints[i] = direction ? BinaryCoordinateRotationUtils3D.rotateNPointRight(this.npointValues[i]) : BinaryCoordinateRotationUtils3D.rotateNPointLeft(this.npointValues[i]);
            }
            return new HilbertCurve3D(newNpoints);
        }

        private HilbertCurve3D rotateOneThirdDiagonalNeg(boolean direction) {
            int[] newNpoints = new int[this.length()];
            for (int i = 0; i < this.length(); ++i) {
                newNpoints[i] = direction ? BinaryCoordinateRotationUtils3D.xXOR(BinaryCoordinateRotationUtils3D.rotateNPointLeft(BinaryCoordinateRotationUtils3D.xXOR(this.npointValues[i]))) : BinaryCoordinateRotationUtils3D.xXOR(BinaryCoordinateRotationUtils3D.rotateNPointRight(BinaryCoordinateRotationUtils3D.xXOR(this.npointValues[i])));
            }
            return new HilbertCurve3D(newNpoints);
        }

        private HilbertCurve3D rotateAboutX() {
            int[] newNpoints = new int[this.length()];
            for (int i = 0; i < this.length(); ++i) {
                newNpoints[i] = BinaryCoordinateRotationUtils3D.rotateYZ(this.npointValues[i]);
            }
            return new HilbertCurve3D(newNpoints);
        }

        private void buildCurveTree(Map<SubCurve3D, HilbertCurve3D> curves) {
            if (this.children == null) {
                this.makeChildren(curves);
                curves.put(this.name(), this);
                for (HilbertCurve3D child : this.children) {
                    child.buildCurveTree(curves);
                }
            }
        }

        private void makeChildren(Map<SubCurve3D, HilbertCurve3D> curves) {
            this.children = new HilbertCurve3D[this.length()];
            this.children[0] = HilbertCurve3D.singleton(curves, this.rotateOneThirdDiagonalPos(true));
            this.children[1] = HilbertCurve3D.singleton(curves, this.rotateOneThirdDiagonalPos(false));
            this.children[2] = HilbertCurve3D.singleton(curves, this.rotateOneThirdDiagonalPos(false));
            this.children[3] = HilbertCurve3D.singleton(curves, this.rotateAboutX());
            this.children[4] = HilbertCurve3D.singleton(curves, this.rotateAboutX());
            this.children[5] = HilbertCurve3D.singleton(curves, this.rotateOneThirdDiagonalNeg(true));
            this.children[6] = HilbertCurve3D.singleton(curves, this.rotateOneThirdDiagonalNeg(true));
            this.children[7] = HilbertCurve3D.singleton(curves, this.rotateOneThirdDiagonalNeg(false));
        }

        private static HilbertCurve3D singleton(Map<SubCurve3D, HilbertCurve3D> curves, HilbertCurve3D newCurve) {
            return curves.computeIfAbsent(newCurve.name(), key -> newCurve);
        }
    }

    static class SubCurve3D {
        private final Direction3D firstMove;
        private final Direction3D secondMove;
        private final Direction3D overallDirection;

        SubCurve3D(Direction3D firstMove, Direction3D secondMove, Direction3D overallDirection) {
            this.firstMove = firstMove;
            this.secondMove = secondMove;
            this.overallDirection = overallDirection;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.firstMove, this.secondMove, this.overallDirection});
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SubCurve3D other = (SubCurve3D)obj;
            return this.firstMove == other.firstMove && this.secondMove == other.secondMove && this.overallDirection == other.overallDirection;
        }

        public String toString() {
            return this.firstMove.toString() + this.secondMove + this.overallDirection;
        }
    }

    static enum Direction3D {
        UP,
        RIGHT,
        LEFT,
        DOWN,
        FRONT,
        BACK;

    }

    static class BinaryCoordinateRotationUtils3D {
        BinaryCoordinateRotationUtils3D() {
        }

        static int rotateNPointLeft(int value) {
            return value << 1 & 7 | (value & 4) >> 2;
        }

        static int rotateNPointRight(int value) {
            return value >> 1 | (value & 1) << 2;
        }

        static int xXOR(int value) {
            return value ^ 4;
        }

        static int rotateYZ(int value) {
            return value ^ 3;
        }
    }
}

