/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl.config;

import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.ssl.config.ScopedSslPolicyProvider;
import org.neo4j.ssl.config.SslPolicyChangeListener;
import org.neo4j.ssl.config.SslPolicyProvider;

public class DefaultScopedSslPolicyProvider
implements ScopedSslPolicyProvider {
    private final SslPolicyScope scope;
    private final SslPolicyProvider provider;

    public DefaultScopedSslPolicyProvider(SslPolicyScope scope, SslPolicyProvider provider) {
        this.scope = scope;
        this.provider = provider;
    }

    @Override
    public SslPolicy getPolicy() {
        return this.provider.hasPolicyForScope(this.scope) ? this.provider.getPolicy(this.scope) : null;
    }

    @Override
    public void addPolicyChangeListener(SslPolicyChangeListener listener) {
        this.provider.addPolicyChangeListener(listener);
    }

    @Override
    public void removePolicyChangeListener(SslPolicyChangeListener listener) {
        this.provider.removePolicyChangeListener(listener);
    }

    public String toString() {
        boolean hasPolicy = this.provider.hasPolicyForScope(this.scope);
        return String.format("DefaultScopedSslPolicyProvider %s, hasPolicy=%b policy=%s", this.scope.name(), hasPolicy, hasPolicy ? this.provider.getPolicy(this.scope) : null);
    }
}

