/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl.config;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.ssl.config.SslPolicyChangeListener;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.ssl.config.SslPolicyProvider;

public class DefaultSslPolicyProvider
implements SslPolicyProvider {
    private final FileSystemAbstraction fileSystem;
    private final Config config;
    private final boolean enableReload;
    private final InternalLogProvider logProvider;
    private SslPolicyLoader policyLoader;
    private final Set<SslPolicyChangeListener> listeners = new HashSet<SslPolicyChangeListener>();

    public DefaultSslPolicyProvider(FileSystemAbstraction fileSystem, Config config, boolean enableReload, InternalLogProvider logProvider) {
        this.fileSystem = fileSystem;
        this.config = config;
        this.enableReload = enableReload;
        this.logProvider = logProvider;
        this.policyLoader = SslPolicyLoader.create(fileSystem, config, logProvider);
    }

    @Override
    public void reloadPolicies() {
        if (this.enableReload) {
            this.policyLoader = SslPolicyLoader.create(this.fileSystem, this.config, this.logProvider);
            this.notifyListeners();
        }
    }

    private synchronized void notifyListeners() {
        for (SslPolicyScope scope : SslPolicyScope.values()) {
            if (!this.policyLoader.hasPolicyForSource(scope)) continue;
            SslPolicy policy = this.policyLoader.getPolicy(scope);
            this.listeners.forEach(listener -> listener.policyChanged(scope, policy));
        }
    }

    @Override
    public boolean hasPolicyForScope(SslPolicyScope scope) {
        return this.policyLoader.hasPolicyForSource(scope);
    }

    @Override
    public SslPolicy getPolicy(SslPolicyScope scope) {
        return this.policyLoader.getPolicy(scope);
    }

    @Override
    public synchronized void addPolicyChangeListener(SslPolicyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removePolicyChangeListener(SslPolicyChangeListener listener) {
        this.listeners.remove(listener);
    }
}

