/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.neo4j.ssl.InsecureRandom;

public class PkiUtils {
    private static final boolean useInsecureCertificateGeneration = Boolean.getBoolean("org.neo4j.useInsecureCertificateGeneration");
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String DEFAULT_ENCRYPTION = "RSA";
    private final SecureRandom random = useInsecureCertificateGeneration ? new InsecureRandom() : new SecureRandom();
    private static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date NOT_AFTER = new Date(253402300799000L);
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private static volatile boolean cleanupRequired = true;

    public void createSelfSignedCertificate(File certificatePath, File privateKeyPath, String hostName) throws GeneralSecurityException, IOException, OperatorCreationException {
        PkiUtils.installCleanupHook(certificatePath, privateKeyPath);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(DEFAULT_ENCRYPTION);
        keyGen.initialize(2048, this.random);
        KeyPair keypair = keyGen.generateKeyPair();
        X500Name owner = new X500Name("CN=" + hostName);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, this.random), NOT_BEFORE, NOT_AFTER, owner, keypair.getPublic());
        PrivateKey privateKey = keypair.getPrivate();
        ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSAEncryption").build(privateKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        this.writePem("CERTIFICATE", cert.getEncoded(), certificatePath);
        this.writePem("PRIVATE KEY", privateKey.getEncoded(), privateKeyPath);
        cleanupRequired = false;
    }

    private static void installCleanupHook(File certificatePath, File privateKeyPath) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (cleanupRequired) {
                System.err.println("Cleaning up partially generated self-signed certificate...");
                if (certificatePath.exists()) {
                    certificatePath.delete();
                }
                if (privateKeyPath.exists()) {
                    privateKeyPath.delete();
                }
            }
        }));
    }

    public X509Certificate[] loadCertificates(File certFile) throws CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
        Collection<? extends Certificate> certificates = new LinkedList<Certificate>();
        try (PemReader r = new PemReader((Reader)new FileReader(certFile));){
            PemObject pemObject = r.readPemObject();
            while (pemObject != null) {
                byte[] encodedCert = pemObject.getContent();
                Collection<? extends Certificate> loadedCertificates = certFactory.generateCertificates(new ByteArrayInputStream(encodedCert));
                certificates.addAll(loadedCertificates);
                pemObject = r.readPemObject();
            }
        }
        if (certificates.size() == 0) {
            var5_5 = null;
            try (FileInputStream in = new FileInputStream(certFile);){
                certificates = certFactory.generateCertificates(in);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }

    /*
     * Loose catch block
     */
    public PrivateKey loadPrivateKey(File privateKeyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        Throwable throwable;
        block39: {
            throwable = null;
            try (PemReader r = new PemReader((Reader)new FileReader(privateKeyFile));){
                PemObject pemObject2222 = r.readPemObject();
                if (pemObject2222 == null) break block39;
                byte[] encodedKey = pemObject2222.getContent();
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                try {
                    PrivateKey privateKey = KeyFactory.getInstance(DEFAULT_ENCRYPTION).generatePrivate(keySpec);
                    return privateKey;
                }
                catch (InvalidKeySpecException ignore) {
                    PrivateKey privateKey;
                    block40: {
                        block41: {
                            privateKey = KeyFactory.getInstance("DSA").generatePrivate(keySpec);
                            if (r == null) break block40;
                            if (throwable == null) break block41;
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block40;
                        }
                        r.close();
                    }
                    return privateKey;
                    {
                        catch (InvalidKeySpecException ignore2) {
                            PrivateKey privateKey2;
                            block42: {
                                block43: {
                                    privateKey2 = KeyFactory.getInstance("EC").generatePrivate(keySpec);
                                    if (r == null) break block42;
                                    if (throwable == null) break block43;
                                    try {
                                        r.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    break block42;
                                }
                                r.close();
                            }
                            return privateKey2;
                            {
                                catch (InvalidKeySpecException e) {
                                    try {
                                        throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", e);
                                    }
                                    catch (Throwable pemObject2222) {
                                        throwable = pemObject2222;
                                        throw pemObject2222;
                                    }
                                    catch (Throwable throwable4) {
                                        throw throwable4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        throwable = null;
        try (DataInputStream in = new DataInputStream(new FileInputStream(privateKeyFile));){
            byte[] keyBytes = new byte[(int)privateKeyFile.length()];
            in.readFully(keyBytes);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey privateKey = KeyFactory.getInstance(DEFAULT_ENCRYPTION).generatePrivate(keySpec);
            return privateKey;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
    }

    private void writePem(String type, byte[] encodedContent, File path) throws IOException {
        path.getParentFile().mkdirs();
        try (PemWriter writer = new PemWriter((Writer)new FileWriter(path));){
            writer.writeObject((PemObjectGenerator)new PemObject(type, encodedContent));
            writer.flush();
        }
        path.setReadable(false, false);
        path.setWritable(false, false);
        path.setReadable(true);
        path.setWritable(true);
    }

    static {
        Security.addProvider(PROVIDER);
    }
}

