/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public final class PkiUtils {
    public static final String CERTIFICATE_TYPE = "X.509";
    private static final Provider PROVIDER = new BouncyCastleProvider();

    private PkiUtils() {
    }

    public static X509Certificate[] loadCertificates(Path certFile) throws CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
        LinkedList<? extends Certificate> certificates = new LinkedList<Certificate>();
        try (PemReader r = new PemReader((Reader)Files.newBufferedReader(certFile));){
            PemObject pemObject = r.readPemObject();
            while (pemObject != null) {
                byte[] encodedCert = pemObject.getContent();
                Collection<? extends Certificate> loadedCertificates = certFactory.generateCertificates(new ByteArrayInputStream(encodedCert));
                certificates.addAll(loadedCertificates);
                pemObject = r.readPemObject();
            }
            X509Certificate[] x509CertificateArray = certificates.toArray(new X509Certificate[0]);
            return x509CertificateArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey loadPrivateKey(Path privateKeyFile, String passPhrase) throws IOException {
        if (passPhrase == null) {
            passPhrase = "";
        }
        try (PEMParser r = new PEMParser((Reader)Files.newBufferedReader(privateKeyFile));){
            Object pemObject = r.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(PROVIDER);
            if (pemObject instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)pemObject;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(passPhrase.toCharArray());
                PrivateKey privateKey = converter.getKeyPair(ckp.decryptKeyPair(decProv)).getPrivate();
                return privateKey;
            }
            if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                try {
                    PKCS8EncryptedPrivateKeyInfo encryptedInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                    InputDecryptorProvider provider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passPhrase.toCharArray());
                    PrivateKeyInfo privateKeyInfo = encryptedInfo.decryptPrivateKeyInfo(provider);
                    PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
                    return privateKey;
                }
                catch (OperatorCreationException | PKCSException e) {
                    throw new IOException("Unable to decrypt private key.", e);
                }
            }
            if (pemObject instanceof PrivateKeyInfo) {
                PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)pemObject);
                return privateKey;
            }
            if (!(pemObject instanceof PEMKeyPair)) throw new IOException("Unrecognized private key format.");
            PrivateKey privateKey = converter.getKeyPair((PEMKeyPair)pemObject).getPrivate();
            return privateKey;
        }
    }

    static {
        Security.addProvider(PROVIDER);
    }
}

