/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

public enum RelationshipDirection {
    OUTGOING(0),
    INCOMING(1),
    LOOP(2),
    ERROR(3);

    private static final RelationshipDirection[] DIRECTIONS_BY_ID;
    private final int id;

    public static RelationshipDirection ofId(int id) {
        return DIRECTIONS_BY_ID[id];
    }

    public static RelationshipDirection directionOfStrict(long nodeReference, long sourceNodeReference, long targetNodeReference) {
        if (sourceNodeReference == nodeReference) {
            return targetNodeReference == nodeReference ? LOOP : OUTGOING;
        }
        if (targetNodeReference == nodeReference) {
            return INCOMING;
        }
        throw new IllegalStateException("Traversed relationship that wasn't part of the origin node:" + nodeReference + ". The encountered relationship has source:" + sourceNodeReference + " and target:" + targetNodeReference);
    }

    private RelationshipDirection(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    static {
        DIRECTIONS_BY_ID = new RelationshipDirection[]{OUTGOING, INCOMING, LOOP, ERROR};
    }
}

