/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

public interface Collector
extends AutoCloseable {
    public static final Collector EMPTY = new Collector(){

        @Override
        public void collectExtraColumns(String source, long row, String value) {
        }

        @Override
        public void close() {
        }

        @Override
        public long badEntries() {
            return 0L;
        }

        @Override
        public void collectBadRelationship(Object startId, String startIdGroup, String type, Object endId, String endIdGroup, Object specificValue) {
        }

        @Override
        public void collectDuplicateNode(Object id, long actualId, String group) {
        }

        @Override
        public boolean isCollectingBadRelationships() {
            return true;
        }
    };
    public static final Collector STRICT = new Collector(){

        @Override
        public void collectExtraColumns(String source, long row, String value) {
            throw new IllegalStateException(String.format("Bad extra column '%s' index:%d in '%s'", value, row, source));
        }

        @Override
        public void close() {
        }

        @Override
        public long badEntries() {
            return 0L;
        }

        @Override
        public void collectBadRelationship(Object startId, String startIdGroup, String type, Object endId, String endIdGroup, Object specificValue) {
            throw new IllegalStateException(String.format("Bad relationship (%s:%s)-[%s]->(%s:%s) %s", startId, startIdGroup, type, endId, endIdGroup, specificValue));
        }

        @Override
        public void collectDuplicateNode(Object id, long actualId, String group) {
            throw new IllegalStateException(String.format("Bad duplicate node %s:%s id:%d", id, group, actualId));
        }

        @Override
        public boolean isCollectingBadRelationships() {
            return false;
        }
    };

    public void collectBadRelationship(Object var1, String var2, String var3, Object var4, String var5, Object var6);

    public void collectDuplicateNode(Object var1, long var2, String var4);

    public void collectExtraColumns(String var1, long var2, String var4);

    public long badEntries();

    public boolean isCollectingBadRelationships();

    @Override
    public void close();
}

