/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.annotations.service.Service;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.migration.RollingUpgradeCompatibility;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.token.TokenHolders;

@Service
public interface StorageEngineFactory {
    public static final Selector SELECTOR = StorageEngineFactory::selectStorageEngine;

    public String name();

    public StoreVersionCheck versionCheck(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, LogService var5, PageCacheTracer var6);

    public StoreVersion versionInformation(String var1);

    public StoreVersion versionInformation(StoreId var1);

    public RollingUpgradeCompatibility rollingUpgradeCompatibility();

    public List<StoreMigrationParticipant> migrationParticipants(FileSystemAbstraction var1, Config var2, PageCache var3, JobScheduler var4, LogService var5, PageCacheTracer var6, MemoryTracker var7);

    public StorageEngine instantiate(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, TokenHolders var5, SchemaState var6, ConstraintRuleAccessor var7, IndexConfigCompleter var8, LockService var9, IdGeneratorFactory var10, IdController var11, DatabaseHealth var12, LogProvider var13, LogProvider var14, RecoveryCleanupWorkCollector var15, PageCacheTracer var16, boolean var17, DatabaseReadOnlyChecker var18, MemoryTracker var19);

    public List<Path> listStorageFiles(FileSystemAbstraction var1, DatabaseLayout var2) throws IOException;

    public boolean storageExists(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3);

    public TransactionIdStore readOnlyTransactionIdStore(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, CursorContext var4) throws IOException;

    public LogVersionRepository readOnlyLogVersionRepository(DatabaseLayout var1, PageCache var2, CursorContext var3) throws IOException;

    public MetadataProvider transactionMetaDataStore(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, PageCacheTracer var5, DatabaseReadOnlyChecker var6) throws IOException;

    public StoreId storeId(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, CursorContext var4) throws IOException;

    public void setStoreId(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, CursorContext var4, StoreId var5, long var6, long var8) throws IOException;

    public void setExternalStoreUUID(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, CursorContext var4, UUID var5) throws IOException;

    public Optional<UUID> databaseIdUuid(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, CursorContext var4);

    public SchemaRuleMigrationAccess schemaRuleMigrationAccess(FileSystemAbstraction var1, PageCache var2, Config var3, DatabaseLayout var4, LogService var5, String var6, PageCacheTracer var7, CursorContext var8, MemoryTracker var9);

    public List<SchemaRule> loadSchemaRules(FileSystemAbstraction var1, PageCache var2, Config var3, DatabaseLayout var4, CursorContext var5);

    public StorageFilesState checkStoreFileState(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3);

    public CommandReaderFactory commandReaderFactory();

    public DatabaseLayout databaseLayout(Neo4jLayout var1, String var2);

    public static StorageEngineFactory defaultStorageEngine() {
        return StorageEngineFactory.selectStorageEngine("record");
    }

    public static Collection<StorageEngineFactory> allAvailableStorageEngines() {
        return Services.loadAll(StorageEngineFactory.class);
    }

    public static Optional<StorageEngineFactory> selectStorageEngine(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache) {
        Collection<StorageEngineFactory> storageEngineFactories = StorageEngineFactory.allAvailableStorageEngines();
        return storageEngineFactories.stream().filter(engine -> engine.storageExists(fs, databaseLayout, pageCache)).findFirst();
    }

    public static StorageEngineFactory selectStorageEngine(String name) {
        Collection storageEnginesWithThisName = StorageEngineFactory.allAvailableStorageEngines().stream().filter(e -> e.name().equals(name)).collect(Collectors.toList());
        if (storageEnginesWithThisName.isEmpty()) {
            throw new IllegalArgumentException("No storage engine matching name '" + name + "'. Available storage engines are: " + StorageEngineFactory.allAvailableStorageEngines().stream().map(e -> "'" + e.name() + "'").collect(Collectors.joining(", ")));
        }
        return (StorageEngineFactory)Iterables.single((Iterable)storageEnginesWithThisName);
    }

    public static StorageEngineFactory selectStorageEngine(Configuration configuration) {
        return StorageEngineFactory.selectStorageEngine((String)configuration.get(GraphDatabaseInternalSettings.storage_engine));
    }

    public static StorageEngineFactory selectStorageEngine(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, Configuration configuration) {
        return StorageEngineFactory.selectStorageEngine(fs, databaseLayout, pageCache, configuration != null ? (String)configuration.get(GraphDatabaseInternalSettings.storage_engine) : null);
    }

    public static StorageEngineFactory selectStorageEngine(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, String specificNameOrNull) {
        Optional<StorageEngineFactory> forExistingStore = StorageEngineFactory.selectStorageEngine(fs, databaseLayout, pageCache);
        if (forExistingStore.isPresent()) {
            return forExistingStore.get();
        }
        if (StringUtils.isNotEmpty((CharSequence)specificNameOrNull)) {
            return StorageEngineFactory.selectStorageEngine(specificNameOrNull);
        }
        return StorageEngineFactory.defaultStorageEngine();
    }

    public static interface Selector {
        public Optional<StorageEngineFactory> selectStorageEngine(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3);
    }
}

