/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsValue;
import org.neo4j.io.pagecache.PageCursor;

public class CountsLayout
extends Layout.Adapter<CountsKey, CountsValue> {
    public CountsLayout() {
        super(true, Layout.namedIdentifier((String)"CoLa", (int)987), 0, 1);
    }

    public CountsKey newKey() {
        return new CountsKey();
    }

    public CountsKey copyKey(CountsKey key, CountsKey into) {
        into.initialize(key.type, key.first, key.second);
        return into;
    }

    public CountsValue newValue() {
        return new CountsValue();
    }

    public int keySize(CountsKey key) {
        return 13;
    }

    public int valueSize(CountsValue value) {
        return 8;
    }

    public void writeKey(PageCursor cursor, CountsKey key) {
        cursor.putByte(key.type);
        cursor.putLong(key.first);
        cursor.putInt(key.second);
    }

    public void writeValue(PageCursor cursor, CountsValue value) {
        cursor.putLong(value.count);
    }

    public void readKey(PageCursor cursor, CountsKey into, int keySize) {
        byte type = cursor.getByte();
        long first = cursor.getLong();
        int second = cursor.getInt();
        into.initialize(type, first, second);
    }

    public void readValue(PageCursor cursor, CountsValue into, int valueSize) {
        into.initialize(cursor.getLong());
    }

    public int compare(CountsKey o1, CountsKey o2) {
        int typeCompare = Byte.compare(o1.type, o2.type);
        if (typeCompare != 0) {
            return typeCompare;
        }
        int keyFirstCompare = Long.compare(o1.first, o2.first);
        if (keyFirstCompare != 0) {
            return keyFirstCompare;
        }
        return Integer.compare(o1.second, o2.second);
    }

    public void initializeAsLowest(CountsKey key) {
        key.initialize((byte)-128, Long.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void initializeAsHighest(CountsKey key) {
        key.initialize((byte)127, Long.MAX_VALUE, Integer.MAX_VALUE);
    }
}

