/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.codec;

import java.util.Arrays;
import org.neo4j.util.Bits;

public abstract class ShortStringCodec
extends Enum<ShortStringCodec> {
    public static final /* enum */ ShortStringCodec NUMERICAL;
    public static final /* enum */ ShortStringCodec DATE;
    public static final /* enum */ ShortStringCodec UPPER;
    public static final /* enum */ ShortStringCodec LOWER;
    public static final /* enum */ ShortStringCodec EMAIL;
    public static final /* enum */ ShortStringCodec URI;
    public static final /* enum */ ShortStringCodec ALPHANUM;
    public static final /* enum */ ShortStringCodec ALPHASYM;
    public static final /* enum */ ShortStringCodec EUROPEAN;
    public static final /* enum */ ShortStringCodec LOWERHEX;
    public static final /* enum */ ShortStringCodec UPPERHEX;
    public static final ShortStringCodec[] CODECS;
    public static final int CODEC_COUNT;
    public static final int ALL_BIT_MASK;
    public static final int ENCODING_UTF8 = 0;
    public static final int ENCODING_LATIN1 = 10;
    private static final byte[] PUNCTUATION;
    private static final int TRANSLATION_COUNT = 256;
    private static final byte[] TRANSLATION;
    private static final int[] REMOVE_MASK;
    private static final ShortStringCodec[] CODEC_BY_ID;
    final int codecId;
    final long mask;
    final int step;
    final boolean needsChars;
    private static final /* synthetic */ ShortStringCodec[] $VALUES;

    public static ShortStringCodec[] values() {
        return (ShortStringCodec[])$VALUES.clone();
    }

    public static ShortStringCodec valueOf(String name) {
        return Enum.valueOf(ShortStringCodec.class, name);
    }

    private static void setUp(char pos, int value, ShortStringCodec ... removeCodecs) {
        ShortStringCodec.TRANSLATION[pos] = (byte)value;
        ShortStringCodec.REMOVE_MASK[pos] = ~ShortStringCodec.bitMask(removeCodecs);
        ShortStringCodec[] shortStringCodecArray = CODECS;
        int n = shortStringCodecArray.length;
        for (int i = 0; i < n; ++i) {
            ShortStringCodec codec;
            ShortStringCodec.CODEC_BY_ID[codec.codecId] = codec = shortStringCodecArray[i];
        }
    }

    private ShortStringCodec(int codecId, int step, boolean needsChars) {
        this.codecId = codecId;
        this.mask = Bits.rightOverflowMask((int)step);
        this.step = step;
        this.needsChars = needsChars;
    }

    public static ShortStringCodec lowestCodec(int compatibleCodecs) {
        return ShortStringCodec.codecById(Integer.numberOfTrailingZeros(compatibleCodecs) + 1);
    }

    public int bitMask() {
        return 1 << this.ordinal();
    }

    public int bitsPerCharacter() {
        return this.step;
    }

    public boolean needsChars() {
        return this.needsChars;
    }

    public long mask() {
        return this.mask;
    }

    public int id() {
        return this.codecId;
    }

    public static int bitMask(ShortStringCodec ... codecs) {
        int result = 0;
        for (ShortStringCodec codec : codecs) {
            result |= codec.bitMask();
        }
        return result;
    }

    final IllegalArgumentException cannotEncode(byte b) {
        return new IllegalArgumentException("Cannot encode as " + this.name() + ": " + b);
    }

    byte decPunctuation(int code) {
        return PUNCTUATION[code];
    }

    public int encTranslate(byte b) {
        if (b < 0) {
            return (0xFF & b) - 192;
        }
        if (b < 32) {
            return this.encPunctuation(b);
        }
        if (b >= 48 && b <= 52) {
            return 91 + b - 48;
        }
        if (b >= 53 && b <= 57) {
            return 123 + b - 53;
        }
        return b;
    }

    abstract int encPunctuation(byte var1);

    public abstract byte decTranslate(byte var1);

    public static int prepareEncode(String string, byte[] data, int stringLength) {
        if (stringLength == 0) {
            return 0;
        }
        int encodings = ALL_BIT_MASK;
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0100') {
                return 0;
            }
            data[i] = TRANSLATION[c];
            if ((encodings &= REMOVE_MASK[c]) != 0) continue;
            return 0;
        }
        return encodings;
    }

    public static ShortStringCodec codecById(int id) {
        if (id < 0 || CODEC_BY_ID.length <= id) {
            return null;
        }
        return CODEC_BY_ID[id];
    }

    static {
        char c;
        NUMERICAL = new ShortStringCodec(1, 4, false){

            @Override
            public int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                switch (b) {
                    case 0: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                    case 3: {
                        return 12;
                    }
                    case 6: {
                        return 13;
                    }
                    case 7: {
                        return 14;
                    }
                    case 8: {
                        return 15;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (byte)(codePoint + 48);
                }
                return this.decPunctuation(codePoint - 10 + 6);
            }
        };
        DATE = new ShortStringCodec(2, 4, false){

            @Override
            public int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                switch (b) {
                    case 0: {
                        return 10;
                    }
                    case 3: {
                        return 11;
                    }
                    case 4: {
                        return 12;
                    }
                    case 5: {
                        return 13;
                    }
                    case 6: {
                        return 14;
                    }
                    case 7: {
                        return 15;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (byte)(codePoint + 48);
                }
                switch (codePoint) {
                    case 10: {
                        return 32;
                    }
                    case 11: {
                        return 45;
                    }
                    case 12: {
                        return 58;
                    }
                    case 13: {
                        return 47;
                    }
                    case 14: {
                        return 43;
                    }
                }
                return 44;
            }
        };
        UPPER = new ShortStringCodec(3, 5, false){

            @Override
            public int encTranslate(byte b) {
                return super.encTranslate(b) - 64;
            }

            @Override
            int encPunctuation(byte b) {
                return b == 0 ? 64 : b + 90;
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return 32;
                }
                if (codePoint <= 26) {
                    return (byte)(codePoint + 65 - 1);
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        LOWER = new ShortStringCodec(4, 5, false){

            @Override
            public int encTranslate(byte b) {
                return super.encTranslate(b) - 96;
            }

            @Override
            int encPunctuation(byte b) {
                return b == 0 ? 96 : b + 122;
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return 32;
                }
                if (codePoint <= 26) {
                    return (byte)(codePoint + 97 - 1);
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        EMAIL = new ShortStringCodec(5, 5, false){

            @Override
            public int encTranslate(byte b) {
                return super.encTranslate(b) - 96;
            }

            @Override
            int encPunctuation(byte b) {
                int encOffset = 96;
                if (b == 7) {
                    return encOffset;
                }
                int offset = encOffset + 27;
                switch (b) {
                    case 1: {
                        return offset;
                    }
                    case 2: {
                        return 1 + offset;
                    }
                    case 3: {
                        return 2 + offset;
                    }
                    case 6: {
                        return 3 + offset;
                    }
                    case 9: {
                        return 4 + offset;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return 44;
                }
                if (codePoint <= 26) {
                    return (byte)(codePoint + 97 - 1);
                }
                switch (codePoint) {
                    case 30: {
                        return 43;
                    }
                    case 31: {
                        return 64;
                    }
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        URI = new ShortStringCodec(6, 6, false){

            @Override
            public int encTranslate(byte b) {
                if (b == 0) {
                    return 0;
                }
                if (b >= 97 && b <= 122) {
                    return b - 96;
                }
                if (b >= 48 && b <= 57) {
                    return b - 16;
                }
                if (b >= 1 && b <= 22) {
                    return b + 41;
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return 32;
                }
                if (codePoint <= 26) {
                    return (byte)(codePoint + 97 - 1);
                }
                if (codePoint <= 41) {
                    return (byte)(codePoint - 32 + 48);
                }
                if (codePoint <= 46) {
                    return this.decPunctuation(codePoint - 41);
                }
                return this.decPunctuation(codePoint - 47 + 9);
            }
        };
        ALPHANUM = new ShortStringCodec(7, 6, false){

            @Override
            public byte decTranslate(byte codePoint) {
                return EUROPEAN.decTranslate((byte)(codePoint + 64));
            }

            @Override
            public int encTranslate(byte b) {
                if (b < 32) {
                    return this.encPunctuation(b);
                }
                return EUROPEAN.encTranslate(b) - 64;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 32;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        ALPHASYM = new ShortStringCodec(8, 6, false){

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return 32;
                }
                if (codePoint <= 26) {
                    return (byte)(65 + codePoint - 1);
                }
                if (codePoint <= 31) {
                    return this.decPunctuation(codePoint - 27 + 1);
                }
                if (codePoint == 32) {
                    return 59;
                }
                if (codePoint <= 58) {
                    return (byte)(97 + codePoint - 33);
                }
                return this.decPunctuation(codePoint - 59 + 9);
            }

            @Override
            public int encTranslate(byte b) {
                if (b < 32) {
                    return this.encPunctuation(b);
                }
                return b - 64;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 27;
                    }
                    case 2: {
                        return 28;
                    }
                    case 3: {
                        return 29;
                    }
                    case 4: {
                        return 30;
                    }
                    case 5: {
                        return 31;
                    }
                    case 6: {
                        return 59;
                    }
                    case 7: {
                        return 60;
                    }
                    case 8: {
                        return 61;
                    }
                    case 9: {
                        return 62;
                    }
                    case 10: {
                        return 63;
                    }
                    case 11: {
                        return 32;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        EUROPEAN = new ShortStringCodec(9, 7, true){

            @Override
            public byte decTranslate(byte codePoint) {
                int code = codePoint & 0xFF;
                if (code < 64) {
                    if (code == 23) {
                        return 46;
                    }
                    if (code == 55) {
                        return 45;
                    }
                    return (byte)(code + 192);
                }
                if (code == 64) {
                    return 32;
                }
                if (code == 96) {
                    return 95;
                }
                if (code >= 91 && code < 96) {
                    return (byte)(48 + code - 91);
                }
                if (code >= 123 && code < 128) {
                    return (byte)(53 + code - 123);
                }
                return (byte)code;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 64;
                    }
                    case 1: {
                        return 96;
                    }
                    case 2: {
                        return 23;
                    }
                    case 3: {
                        return 55;
                    }
                    case 7: {
                        return 0;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        LOWERHEX = new ShortStringCodec(11, 4, false){

            @Override
            public int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                if (b >= 97 && b <= 102) {
                    return b - 97 + 10;
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (byte)(codePoint + 48);
                }
                return (byte)(codePoint + 97 - 10);
            }
        };
        UPPERHEX = new ShortStringCodec(12, 4, false){

            @Override
            public int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                if (b >= 65 && b <= 70) {
                    return b - 65 + 10;
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            public byte decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (byte)(codePoint + 48);
                }
                return (byte)(codePoint + 65 - 10);
            }
        };
        $VALUES = new ShortStringCodec[]{NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, ALPHASYM, EUROPEAN, LOWERHEX, UPPERHEX};
        CODECS = ShortStringCodec.values();
        CODEC_COUNT = CODECS.length;
        ALL_BIT_MASK = ShortStringCodec.bitMask(CODECS);
        PUNCTUATION = new byte[]{32, 95, 46, 45, 58, 47, 32, 46, 45, 43, 44, 39, 64, 124, 59, 42, 63, 38, 37, 35, 40, 41, 36, 60, 62, 61};
        TRANSLATION = new byte[256];
        REMOVE_MASK = new int[256];
        CODEC_BY_ID = new ShortStringCodec[CODEC_COUNT + 2];
        Arrays.fill(TRANSLATION, (byte)-1);
        Arrays.fill(REMOVE_MASK, ~ShortStringCodec.bitMask(CODECS));
        ShortStringCodec.setUp(' ', 0, EMAIL, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('_', 1, NUMERICAL, DATE, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('.', 2, DATE, ALPHANUM, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('-', 3, ALPHANUM, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp(':', 4, ALPHANUM, NUMERICAL, EUROPEAN, EMAIL, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('/', 5, ALPHANUM, NUMERICAL, EUROPEAN, EMAIL, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('+', 6, UPPER, LOWER, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp(',', 7, UPPER, LOWER, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('\'', 8, DATE, UPPER, LOWER, EMAIL, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('@', 9, NUMERICAL, DATE, UPPER, LOWER, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        ShortStringCodec.setUp('|', 10, NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        ShortStringCodec[] retainUri = new ShortStringCodec[]{NUMERICAL, DATE, UPPER, LOWER, EMAIL, ALPHANUM, ALPHASYM, EUROPEAN, LOWERHEX, UPPERHEX};
        ShortStringCodec.setUp(';', 11, retainUri);
        ShortStringCodec.setUp('*', 12, retainUri);
        ShortStringCodec.setUp('?', 13, retainUri);
        ShortStringCodec.setUp('&', 14, retainUri);
        ShortStringCodec.setUp('%', 15, retainUri);
        ShortStringCodec.setUp('#', 16, retainUri);
        ShortStringCodec.setUp('(', 17, retainUri);
        ShortStringCodec.setUp(')', 18, retainUri);
        ShortStringCodec.setUp('$', 19, retainUri);
        ShortStringCodec.setUp('<', 20, retainUri);
        ShortStringCodec.setUp('>', 21, retainUri);
        ShortStringCodec.setUp('=', 22, retainUri);
        for (c = 'A'; c <= 'F'; c = (char)(c + '\u0001')) {
            ShortStringCodec.setUp(c, (byte)c, NUMERICAL, DATE, LOWER, EMAIL, URI, LOWERHEX);
        }
        for (c = 'G'; c <= 'Z'; c = (char)(c + '\u0001')) {
            ShortStringCodec.setUp(c, (byte)c, NUMERICAL, DATE, LOWER, EMAIL, URI, LOWERHEX, UPPERHEX);
        }
        for (c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
            ShortStringCodec.setUp(c, (byte)c, NUMERICAL, DATE, UPPER, UPPERHEX);
        }
        for (c = 'g'; c <= 'z'; c = (char)(c + '\u0001')) {
            ShortStringCodec.setUp(c, (byte)c, NUMERICAL, DATE, UPPER, UPPERHEX, LOWERHEX);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            ShortStringCodec.setUp(c, (byte)c, UPPER, LOWER, EMAIL, ALPHASYM);
        }
        for (c = '\u00c0'; c <= '\u00ff'; c = (char)(c + '\u0001')) {
            if (c == 215 || c == 247) continue;
            ShortStringCodec.setUp(c, (byte)c, NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, ALPHASYM, LOWERHEX, UPPERHEX);
        }
    }
}

