/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.service.Service;
import org.neo4j.configuration.Config;
import org.neo4j.counts.CountsStore;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.service.PrioritizedService;
import org.neo4j.service.Services;

@Service
public interface CountsStoreProvider
extends PrioritizedService {
    public CountsStore openCountsStore(PageCache var1, FileSystemAbstraction var2, RecordDatabaseLayout var3, InternalLogProvider var4, RecoveryCleanupWorkCollector var5, Config var6, CursorContextFactory var7, PageCacheTracer var8, ImmutableSet<OpenOption> var9, CountsBuilder var10);

    public static CountsStoreProvider getInstance() {
        return CountsStoreProviderHolder.COUNTS_STORE_PROVIDER;
    }

    public static final class CountsStoreProviderHolder {
        private static final CountsStoreProvider COUNTS_STORE_PROVIDER = CountsStoreProviderHolder.loadProvider();

        private static CountsStoreProvider loadProvider() {
            return (CountsStoreProvider)Services.loadByPriority(CountsStoreProvider.class).orElseThrow(() -> new IllegalStateException("Failed to load instance of " + CountsStoreProvider.class));
        }
    }
}

