/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine;

import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;
    private final int transactionChecksum;
    private final long transactionCommitTimestamp;
    private final LogPosition logPosition;

    public ReadOnlyTransactionIdStore(LogTailMetadata logTailMetadata) {
        TransactionId lastCommittedTransaction = logTailMetadata.getLastCommittedTransaction();
        this.transactionId = lastCommittedTransaction.transactionId();
        this.transactionChecksum = lastCommittedTransaction.checksum();
        this.transactionCommitTimestamp = lastCommittedTransaction.commitTimestamp();
        this.logPosition = logTailMetadata.getLastTransactionLogPosition();
    }

    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long committingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    public TransactionId getLastCommittedTransaction() {
        return new TransactionId(this.transactionId, this.transactionChecksum, 0L);
    }

    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return new ClosedTransactionMetadata(this.transactionId, this.logPosition, this.transactionChecksum, this.transactionCommitTimestamp);
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long logByteOffset, long logVersion) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void transactionClosed(long transactionId, long logVersion, long logByteOffset, int checksum, long commitTimestamp) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }
}

