/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tinkerpop.api.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.tinkerpop.api.Neo4jFactory;
import org.neo4j.tinkerpop.api.Neo4jGraphAPI;
import org.neo4j.tinkerpop.api.impl.Neo4jGraphAPIImpl;

public class Neo4jFactoryImpl
implements Neo4jFactory {
    public Neo4jGraphAPI newGraphDatabase(String path, Map<String, String> config) {
        try {
            if (path.startsWith("file:")) {
                path = new URL(path).getPath();
            }
            GraphDatabaseBuilder builder = this.createGraphDatabaseFactory(config).newEmbeddedDatabaseBuilder(new File(path));
            if (config != null) {
                builder = builder.setConfig(config);
            }
            return new Neo4jGraphAPIImpl(builder.newGraphDatabase());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error handling path " + path, e);
        }
    }

    protected GraphDatabaseFactory createGraphDatabaseFactory(Map<String, String> config) {
        if (config != null && config.containsKey("ha.server_id")) {
            return new HighlyAvailableGraphDatabaseFactory();
        }
        return new GraphDatabaseFactory();
    }
}

