/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tinkerpop.api.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.tinkerpop.api.Neo4jGraphAPI;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jRelationship;
import org.neo4j.tinkerpop.api.Neo4jTx;
import org.neo4j.tinkerpop.api.impl.Neo4jRelationshipImpl;
import org.neo4j.tinkerpop.api.impl.Neo4jTxImpl;
import org.neo4j.tinkerpop.api.impl.Util;

public class Neo4jGraphAPIImpl
implements Neo4jGraphAPI {
    private final GraphDatabaseService db;
    private final GraphProperties graphProps;

    public Neo4jGraphAPIImpl(GraphDatabaseService db) {
        this.db = db;
        this.graphProps = ((NodeManager)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(NodeManager.class)).newGraphProperties();
    }

    public Neo4jNode createNode(String ... labels) {
        return Util.wrap(labels.length == 0 ? this.db.createNode() : this.db.createNode(Util.toLabels(labels)));
    }

    public Neo4jNode getNodeById(long id) {
        return Util.wrap(this.db.getNodeById(id));
    }

    public Neo4jRelationshipImpl getRelationshipById(long id) {
        return Util.wrap(this.db.getRelationshipById(id));
    }

    public void shutdown() {
        this.db.shutdown();
    }

    public Iterable<Neo4jNode> allNodes() {
        return Util.wrapNodes((Iterable<Node>)this.db.getAllNodes());
    }

    public Iterable<Neo4jRelationship> allRelationships() {
        return Util.wrapRels((Iterable<Relationship>)this.db.getAllRelationships());
    }

    public Iterable<Neo4jNode> findNodes(String label) {
        return Util.wrapNodes((ResourceIterator<Node>)this.db.findNodes(Label.label((String)label)));
    }

    public Iterable<Neo4jNode> findNodes(String label, String property, Object value) {
        return Util.wrapNodes((ResourceIterator<Node>)this.db.findNodes(Label.label((String)label), property, value));
    }

    public Neo4jTx tx() {
        return new Neo4jTxImpl(this.db.beginTx());
    }

    public Iterator<Map<String, Object>> execute(String query, Map<String, Object> params) {
        Map<Object, Object> nullSafeParams = params == null ? Collections.emptyMap() : params;
        return new IteratorWrapper<Map<String, Object>, Map<String, Object>>((Iterator)this.db.execute(query, nullSafeParams)){

            protected Map<String, Object> underlyingObjectToObject(Map<String, Object> row) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(row.size());
                for (Map.Entry<String, Object> entry : row.entrySet()) {
                    result.put(entry.getKey(), Util.wrapObject(entry.getValue()));
                }
                return result;
            }
        };
    }

    public boolean hasSchemaIndex(String label, String property) {
        Iterable indexes = this.db.schema().getIndexes(Label.label((String)label));
        for (IndexDefinition index : indexes) {
            for (String prop : index.getPropertyKeys()) {
                if (!prop.equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterable<String> getKeys() {
        return this.graphProps.getPropertyKeys();
    }

    public Object getProperty(String key) {
        return this.graphProps.getProperty(key);
    }

    public boolean hasProperty(String key) {
        return this.graphProps.hasProperty(key);
    }

    public Object removeProperty(String key) {
        return this.graphProps.removeProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.graphProps.setProperty(key, value);
    }

    public String toString() {
        return this.db.toString();
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.db;
    }
}

