/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tinkerpop.api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jRelationship;
import org.neo4j.tinkerpop.api.impl.Neo4jNodeImpl;
import org.neo4j.tinkerpop.api.impl.Neo4jRelationshipImpl;

class Util {
    Util() {
    }

    static Label[] toLabels(String ... labels) {
        Label[] result = new Label[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            result[i] = Label.label((String)labels[i]);
        }
        return result;
    }

    static Set<String> toLabels(Iterable<Label> labels) {
        TreeSet<String> result = new TreeSet<String>();
        for (Label label : labels) {
            result.add(label.name());
        }
        return result;
    }

    static RelationshipType[] types(String ... types) {
        RelationshipType[] result = new RelationshipType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = RelationshipType.withName((String)types[i]);
        }
        return result;
    }

    static Neo4jNode wrap(Node node) {
        return new Neo4jNodeImpl(node);
    }

    static Neo4jRelationshipImpl wrap(Relationship rel) {
        return new Neo4jRelationshipImpl(rel);
    }

    static Iterable<Neo4jNode> wrapNodes(Iterable<Node> nodes) {
        return new IterableWrapper<Neo4jNode, Node>(nodes){

            protected Neo4jNode underlyingObjectToObject(Node node) {
                return Util.wrap(node);
            }
        };
    }

    static Iterable<Neo4jNode> wrapNodes(ResourceIterator<Node> nodes) {
        return new IterableWrapper<Neo4jNode, Node>((Iterable)new SingleIteratorWrapper(nodes)){

            protected Neo4jNode underlyingObjectToObject(Node node) {
                return Util.wrap(node);
            }
        };
    }

    static Iterable<Neo4jRelationship> wrapRels(Iterable<Relationship> rels) {
        return new IterableWrapper<Neo4jRelationship, Relationship>(rels){

            protected Neo4jRelationship underlyingObjectToObject(Relationship rel) {
                return Util.wrap(rel);
            }
        };
    }

    static Object wrapObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Node) {
            return Util.wrap((Node)value);
        }
        if (value instanceof Relationship) {
            return Util.wrap((Relationship)value);
        }
        if (value instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : (Iterable)value) {
                result.add(Util.wrapObject(o));
            }
            return result;
        }
        return value;
    }

    private static class SingleIteratorWrapper
    implements Iterable<Node> {
        private final ResourceIterator<Node> nodes;

        public SingleIteratorWrapper(ResourceIterator<Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodes;
        }
    }
}

