/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import java.util.List;
import java.util.function.IntPredicate;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.token.TokenRegistry;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;

public abstract class AbstractTokenHolderBase
implements TokenHolder {
    final TokenRegistry tokenRegistry;

    public AbstractTokenHolderBase(TokenRegistry tokenRegistry) {
        this.tokenRegistry = tokenRegistry;
    }

    @Override
    public void setInitialTokens(List<NamedToken> tokens) {
        this.tokenRegistry.setInitialTokens(tokens);
    }

    @Override
    public void addToken(NamedToken token, boolean atomic) {
        this.tokenRegistry.put(token);
    }

    @Override
    public int getOrCreateId(String name) throws KernelException {
        return this.innerGetOrCreateId(name, false);
    }

    protected int innerGetOrCreateId(String name, boolean internal) throws KernelException {
        Integer id = this.innerGetId(name, internal);
        if (id != null) {
            return id;
        }
        return this.createToken(name, internal);
    }

    @Override
    public NamedToken getTokenById(int id) throws TokenNotFoundException {
        NamedToken result = this.tokenRegistry.getToken(id);
        if (result == null) {
            throw new TokenNotFoundException("Token for id " + id);
        }
        return result;
    }

    @Override
    public int getIdByName(String name) {
        Integer id = this.tokenRegistry.getId(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    @Override
    public boolean getIdsByNames(String[] names, int[] ids) {
        return this.resolveIds(names, ids, false, Predicates.ALWAYS_FALSE_INT);
    }

    @Override
    public Iterable<NamedToken> getAllTokens() {
        return this.tokenRegistry.allTokens();
    }

    @Override
    public String getTokenType() {
        return this.tokenRegistry.getTokenType();
    }

    @Override
    public boolean hasToken(int id) {
        return this.tokenRegistry.hasToken(id);
    }

    @Override
    public int size() {
        return this.tokenRegistry.size();
    }

    @Override
    public NamedToken getInternalTokenById(int id) throws TokenNotFoundException {
        NamedToken result = this.tokenRegistry.getTokenInternal(id);
        if (result == null) {
            NamedToken alternative = this.tokenRegistry.getToken(id);
            throw new TokenNotFoundException("Internal token for id " + id + " not found" + (String)(alternative != null ? ", but a public token exists on that id: " + alternative + "." : "."));
        }
        return result;
    }

    protected abstract int createToken(String var1, boolean var2) throws KernelException;

    boolean resolveIds(String[] names, int[] ids, boolean internal, IntPredicate unresolvedIndexCheck) {
        boolean foundUnresolvable = false;
        for (int i = 0; i < ids.length; ++i) {
            Integer id = this.innerGetId(names[i], internal);
            if (id != null) {
                ids[i] = id;
                continue;
            }
            foundUnresolvable = true;
            if (unresolvedIndexCheck.test(i)) break;
        }
        return foundUnresolvable;
    }

    private Integer innerGetId(String name, boolean internal) {
        return internal ? this.tokenRegistry.getIdInternal(name) : this.tokenRegistry.getId(name);
    }
}

