/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnspecifiedKernelException;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.token.AbstractTokenHolderBase;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenRegistry;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.NonUniqueTokenException;

public class DelegatingTokenHolder
extends AbstractTokenHolderBase {
    private final TokenCreator tokenCreator;

    public DelegatingTokenHolder(TokenCreator tokenCreator, String tokenType) {
        this(new TokenRegistry(tokenType), tokenCreator);
    }

    private DelegatingTokenHolder(TokenRegistry registry, TokenCreator tokenCreator) {
        super(registry);
        this.tokenCreator = tokenCreator;
    }

    public DelegatingTokenHolder withTokenCreator(TokenCreator tokenCreator) {
        return new DelegatingTokenHolder(this.tokenRegistry, tokenCreator);
    }

    @Override
    protected synchronized int createToken(String name, boolean internal) throws KernelException {
        Integer id;
        Integer n = id = internal ? this.tokenRegistry.getIdInternal(name) : this.tokenRegistry.getId(name);
        if (id != null) {
            return id;
        }
        id = this.tokenCreator.createToken(name, internal);
        try {
            this.tokenRegistry.put(new NamedToken(name, id, internal));
        }
        catch (NonUniqueTokenException e) {
            throw new UnspecifiedKernelException((Status)Status.General.UnknownError, (Throwable)e, "Newly created token should be unique.", new Object[0]);
        }
        return id;
    }

    @Override
    public void getOrCreateIds(String[] names, int[] ids) throws KernelException {
        this.innerBatchGetOrCreate(names, ids, false);
    }

    @Override
    public void getOrCreateInternalIds(String[] names, int[] ids) throws KernelException {
        this.innerBatchGetOrCreate(names, ids, true);
    }

    private void innerBatchGetOrCreate(String[] names, int[] ids, boolean internal) throws KernelException {
        DelegatingTokenHolder.assertSameArrayLength(names, ids);
        boolean hasUnresolvedTokens = this.resolveIds(names, ids, internal, Predicates.ALWAYS_TRUE_INT);
        if (hasUnresolvedTokens) {
            this.createMissingTokens(names, ids, internal);
        }
    }

    private static void assertSameArrayLength(String[] names, int[] ids) {
        if (names.length != ids.length) {
            throw new IllegalArgumentException("Name and id arrays must have the same length.");
        }
    }

    private synchronized void createMissingTokens(String[] names, int[] ids, boolean internal) throws KernelException {
        IntHashSet unresolvedIndexes = new IntHashSet();
        this.resolveIds(names, ids, internal, arg_0 -> DelegatingTokenHolder.lambda$createMissingTokens$0((MutableIntSet)unresolvedIndexes, arg_0));
        if (!unresolvedIndexes.isEmpty()) {
            ObjectIntHashMap<String> createdTokens = this.createUnresolvedTokens((IntSet)unresolvedIndexes, names, ids, internal);
            ArrayList<NamedToken> createdTokensList = new ArrayList<NamedToken>(createdTokens.size());
            createdTokens.forEachKeyValue((ObjectIntProcedure & Serializable)(name, index) -> createdTokensList.add(new NamedToken((String)name, ids[index], internal)));
            this.tokenRegistry.putAll(createdTokensList);
        }
    }

    private ObjectIntHashMap<String> createUnresolvedTokens(IntSet unresolvedIndexes, String[] names, int[] ids, boolean internal) throws KernelException {
        ObjectIntHashMap createdTokens = new ObjectIntHashMap();
        IntIntHashMap remappingIndexes = new IntIntHashMap();
        IntPredicate tokenCreateFilter = index -> {
            String name;
            int creatingIndex;
            boolean needsCreate = unresolvedIndexes.contains(index);
            if (needsCreate && (creatingIndex = createdTokens.getIfAbsentPut((Object)(name = names[index]), index)) != index) {
                remappingIndexes.put(index, creatingIndex);
                needsCreate = false;
            }
            return needsCreate;
        };
        this.tokenCreator.createTokens(names, ids, internal, tokenCreateFilter);
        if (remappingIndexes.notEmpty()) {
            remappingIndexes.forEachKeyValue((IntIntProcedure & Serializable)(index, creatingIndex) -> {
                ids[index] = ids[creatingIndex];
            });
        }
        return createdTokens;
    }

    private static /* synthetic */ boolean lambda$createMissingTokens$0(MutableIntSet unresolvedIndexes, int i) {
        return !unresolvedIndexes.add(i);
    }
}

