/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.UdcInformationCollector;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class DefaultUdcInformationCollector
implements UdcInformationCollector {
    private static final Map<String, String> jarNamesForTags = MapUtil.stringMap((String[])new String[]{"spring-", "spring", "(javax.ejb|ejb-jar)", "ejb", "(weblogic|glassfish|websphere|jboss)", "appserver", "openshift", "openshift", "cloudfoundry", "cloudfoundry", "(junit|testng)", "test", "jruby", "ruby", "clojure", "clojure", "jython", "python", "groovy", "groovy", "(tomcat|jetty)", "web", "spring-data-neo4j", "sdn"});
    private final Config config;
    private final UsageData usageData;
    private String storeId;
    private NeoStoreDataSource neoStoreDataSource;

    DefaultUdcInformationCollector(Config config, DataSourceManager dataSourceManager, UsageData usageData) {
        this.config = config;
        this.usageData = usageData;
        if (dataSourceManager != null) {
            dataSourceManager.addListener(new DataSourceManager.Listener(){

                public void registered(NeoStoreDataSource ds) {
                    DefaultUdcInformationCollector.this.storeId = Long.toHexString(ds.getStoreId().getRandomId());
                    DefaultUdcInformationCollector.this.neoStoreDataSource = ds;
                }

                public void unregistered(NeoStoreDataSource ds) {
                    DefaultUdcInformationCollector.this.storeId = null;
                    DefaultUdcInformationCollector.this.neoStoreDataSource = null;
                }
            });
        }
    }

    static String filterVersionForUDC(String version) {
        if (!version.contains("+")) {
            return version;
        }
        return version.substring(0, version.indexOf(43));
    }

    @Override
    public Map<String, String> getUdcParams() {
        String classPath = DefaultUdcInformationCollector.getClassPath();
        HashMap<String, String> udcFields = new HashMap<String, String>();
        DefaultUdcInformationCollector.add(udcFields, "id", this.storeId);
        DefaultUdcInformationCollector.add(udcFields, "v", DefaultUdcInformationCollector.filterVersionForUDC(this.usageData.get(UsageDataKeys.version)));
        DefaultUdcInformationCollector.add(udcFields, "revision", DefaultUdcInformationCollector.filterVersionForUDC(this.usageData.get(UsageDataKeys.revision)));
        DefaultUdcInformationCollector.add(udcFields, "edition", this.usageData.get(UsageDataKeys.edition).name().toLowerCase());
        DefaultUdcInformationCollector.add(udcFields, "source", this.config.get(UdcSettings.udc_source));
        DefaultUdcInformationCollector.add(udcFields, "reg", this.config.get(UdcSettings.udc_registration_key));
        DefaultUdcInformationCollector.add(udcFields, "databasemode", this.usageData.get(UsageDataKeys.operationalMode).name());
        DefaultUdcInformationCollector.add(udcFields, "serverid", this.usageData.get(UsageDataKeys.serverId));
        DefaultUdcInformationCollector.add(udcFields, "ua", DefaultUdcInformationCollector.toCommaString(this.usageData.get(UsageDataKeys.clientNames)));
        DefaultUdcInformationCollector.add(udcFields, "tags", DefaultUdcInformationCollector.determineTags(jarNamesForTags, classPath));
        DefaultUdcInformationCollector.add(udcFields, "cluster", this.determineClusterNameHash());
        DefaultUdcInformationCollector.add(udcFields, "mac", DefaultUdcInformationCollector.determineMacAddress());
        DefaultUdcInformationCollector.add(udcFields, "dist", DefaultUdcInformationCollector.determineOsDistribution());
        DefaultUdcInformationCollector.add(udcFields, "numprocs", DefaultUdcInformationCollector.determineNumberOfProcessors());
        DefaultUdcInformationCollector.add(udcFields, "totalmem", DefaultUdcInformationCollector.determineTotalMemory());
        DefaultUdcInformationCollector.add(udcFields, "heapsize", DefaultUdcInformationCollector.determineHeapSize());
        DefaultUdcInformationCollector.add(udcFields, "nodeids", this.determineNodesIdsInUse());
        DefaultUdcInformationCollector.add(udcFields, "relids", this.determineRelationshipIdsInUse());
        DefaultUdcInformationCollector.add(udcFields, "labelids", this.determineLabelIdsInUse());
        DefaultUdcInformationCollector.add(udcFields, "propids", this.determinePropertyIdsInUse());
        DefaultUdcInformationCollector.add(udcFields, "features", this.usageData.get(UsageDataKeys.features).asHex());
        this.addStoreFileSizes(udcFields);
        udcFields.putAll(DefaultUdcInformationCollector.determineSystemProperties());
        return udcFields;
    }

    private void addStoreFileSizes(Map<String, String> udcFields) {
        if (this.neoStoreDataSource == null) {
            return;
        }
        DependencyResolver dependencyResolver = this.neoStoreDataSource.getDependencyResolver();
        FileSystemAbstraction fileSystem = (FileSystemAbstraction)dependencyResolver.resolveDependency(FileSystemAbstraction.class);
        long databaseSize = FileUtils.size((FileSystemAbstraction)fileSystem, (File)this.neoStoreDataSource.getDatabaseLayout().databaseDirectory());
        DefaultUdcInformationCollector.add(udcFields, "storesize", databaseSize);
    }

    private static String determineOsDistribution() {
        if (System.getProperties().getProperty("os.name", "").equals("Linux")) {
            return DefaultUdcInformationCollector.searchForPackageSystems();
        }
        return "unknown";
    }

    static String searchForPackageSystems() {
        try {
            if (new File("/bin/rpm").exists()) {
                return "rpm";
            }
            if (new File("/usr/bin/dpkg").exists()) {
                return "dpkg";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private Integer determineClusterNameHash() {
        try {
            Class<?> settings = Class.forName("org.neo4j.cluster.ClusterSettings");
            Setting setting = (Setting)settings.getField("cluster_name").get(null);
            Object name = this.config.get(setting);
            return name != null ? Integer.valueOf(Math.abs(name.hashCode() % Integer.MAX_VALUE)) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String determineTags(Map<String, String> jarNamesForTags, String classPath) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : jarNamesForTags.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            if (!pattern.matcher(classPath).find()) continue;
            result.append(",").append(entry.getValue());
        }
        if (result.length() == 0) {
            return null;
        }
        return result.substring(1);
    }

    private static String getClassPath() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        return runtime.getClassPath();
    }

    private static String determineMacAddress() {
        String formattedMac = "0";
        try {
            byte[] mac;
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            if (ni != null && (mac = ni.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder(mac.length * 2);
                Formatter formatter = new Formatter(sb);
                for (byte b : mac) {
                    formatter.format("%02x", b);
                }
                formattedMac = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return formattedMac;
    }

    private static int determineNumberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static long determineTotalMemory() {
        return OsBeanUtil.getTotalPhysicalMemory();
    }

    private static long determineHeapSize() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    private long determineNodesIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.NODE);
    }

    private long determineLabelIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.LABEL_TOKEN);
    }

    private long determinePropertyIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.PROPERTY);
    }

    private long determineRelationshipIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.RELATIONSHIP);
    }

    private long getNumberOfIdsInUse(IdType type) {
        return ((IdGeneratorFactory)this.neoStoreDataSource.getDependencyResolver().resolveDependency(IdGeneratorFactory.class)).get(type).getNumberOfIdsInUse();
    }

    private static String toCommaString(Object values) {
        StringBuilder result = new StringBuilder();
        if (values instanceof Iterable) {
            for (Object agent : (Iterable)values) {
                if (agent == null) continue;
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(agent);
            }
        } else {
            result.append(values);
        }
        return result.toString();
    }

    private static void add(Map<String, String> udcFields, String name, Object value) {
        if (value == null) {
            return;
        }
        String str = value.toString().trim();
        if (str.isEmpty()) {
            return;
        }
        udcFields.put(name, str);
    }

    private static String removeUdcPrefix(String propertyName) {
        if (propertyName.startsWith("unsupported.dbms.udc")) {
            return propertyName.substring("unsupported.dbms.udc".length() + 1);
        }
        return propertyName;
    }

    private static String sanitizeUdcProperty(String propertyValue) {
        return propertyValue.replace(' ', '_');
    }

    private static Map<String, String> determineSystemProperties() {
        HashMap<String, String> relevantSysProps = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        Enumeration<?> sysPropsNames = sysProps.propertyNames();
        while (sysPropsNames.hasMoreElements()) {
            String sysPropName = (String)sysPropsNames.nextElement();
            if (!sysPropName.startsWith("unsupported.dbms.udc") && !sysPropName.startsWith("os")) continue;
            String propertyValue = sysProps.getProperty(sysPropName);
            relevantSysProps.put(DefaultUdcInformationCollector.removeUdcPrefix(sysPropName), DefaultUdcInformationCollector.sanitizeUdcProperty(propertyValue));
        }
        return relevantSysProps;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }
}

