/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.udc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.udc.UsageDataKey;
import org.neo4j.udc.UsageDataKeys;
import org.neo4j.util.concurrent.DecayingFlags;

public class UsageData
extends LifecycleAdapter {
    private final ConcurrentHashMap<UsageDataKey, Object> store = new ConcurrentHashMap();
    private final JobScheduler scheduler;
    private JobHandle featureDecayJob;

    public UsageData(JobScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public <T> void set(UsageDataKey<T> key, T value) {
        this.store.put(key, value);
    }

    public <T> T get(UsageDataKey<T> key) {
        Object o = this.store.get(key);
        if (o == null) {
            T value = key.generateDefaultValue();
            if (value == null) {
                return null;
            }
            this.store.putIfAbsent(key, value);
            return this.get(key);
        }
        return (T)o;
    }

    public void stop() {
        if (this.featureDecayJob != null) {
            this.featureDecayJob.cancel(false);
        }
    }

    public void start() {
        this.featureDecayJob = this.scheduler.schedule(Group.UDC, () -> ((DecayingFlags)this.get(UsageDataKeys.features)).sweep(), 1L, TimeUnit.DAYS);
    }
}

