/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.os;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public final class OsBeanUtil {
    public static final long VALUE_UNAVAILABLE = -1L;
    private static final String OPENJDK_OS_BEAN = "com.sun.management.OperatingSystemMXBean";
    private static final String OPENJDK_UNIX_OS_BEAN = "com.sun.management.UnixOperatingSystemMXBean";
    private static final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getTotalMemoryMethod = OsBeanUtil.findOsBeanMethod("getTotalMemorySize");
    private static final Method getFreeMemoryMethod = OsBeanUtil.findOsBeanMethod("getFreeMemorySize");
    private static final Method getCommittedVirtualMemoryMethod = OsBeanUtil.findOsBeanMethod("getCommittedVirtualMemorySize");
    private static final Method getTotalSwapSpaceMethod = OsBeanUtil.findOsBeanMethod("getTotalSwapSpaceSize");
    private static final Method getFreeSwapSpaceMethod = OsBeanUtil.findOsBeanMethod("getFreeSwapSpaceSize");
    private static final Method getMaxFileDescriptorsMethod = OsBeanUtil.findUnixOsBeanMethod("getMaxFileDescriptorCount");
    private static final Method getOpenFileDescriptorsMethod = OsBeanUtil.findUnixOsBeanMethod("getOpenFileDescriptorCount");
    private static final Method getCpuLoad = OsBeanUtil.findOsBeanMethod("getCpuLoad");
    private static final Method getProcessCpuLoad = OsBeanUtil.findOsBeanMethod("getProcessCpuLoad");

    private OsBeanUtil() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static long getTotalMemory() {
        return OsBeanUtil.invokeToLong(getTotalMemoryMethod);
    }

    public static long getFreeMemory() {
        return OsBeanUtil.invokeToLong(getFreeMemoryMethod);
    }

    public static long getCommittedVirtualMemory() {
        return OsBeanUtil.invokeToLong(getCommittedVirtualMemoryMethod);
    }

    public static long getTotalSwapSpace() {
        return OsBeanUtil.invokeToLong(getTotalSwapSpaceMethod);
    }

    public static long getFreeSwapSpace() {
        return OsBeanUtil.invokeToLong(getFreeSwapSpaceMethod);
    }

    public static long getMaxFileDescriptors() {
        return OsBeanUtil.invokeToLong(getMaxFileDescriptorsMethod);
    }

    public static long getOpenFileDescriptors() {
        return OsBeanUtil.invokeToLong(getOpenFileDescriptorsMethod);
    }

    public static double getCpuLoad() {
        return OsBeanUtil.invokeToDouble(getCpuLoad);
    }

    public static double getProcessCpuLoad() {
        return OsBeanUtil.invokeToDouble(getProcessCpuLoad);
    }

    private static Method findUnixOsBeanMethod(String methodName) {
        return OsBeanUtil.findMethod(OPENJDK_UNIX_OS_BEAN, methodName);
    }

    private static Method findOsBeanMethod(String methodName) {
        return OsBeanUtil.findMethod(OPENJDK_OS_BEAN, methodName);
    }

    private static Method findMethod(String className, String methodName) {
        try {
            return methodName == null ? null : Class.forName(className).getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static long invokeToLong(Method method) {
        try {
            Object value = method == null ? null : method.invoke((Object)osBean, new Object[0]);
            return value == null ? -1L : ((Number)value).longValue();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    private static double invokeToDouble(Method method) {
        try {
            Object value = method == null ? null : method.invoke((Object)osBean, new Object[0]);
            return value == null ? -1.0 : ((Number)value).doubleValue();
        }
        catch (Throwable t) {
            return -1.0;
        }
    }
}

