/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.unsafe;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

final class UnsafeAccessor {
    private UnsafeAccessor() {
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (Exception e) {
            Class<Unsafe> type = Unsafe.class;
            try {
                Field[] fields;
                for (Field field : fields = type.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    return (Unsafe)type.cast(field.get(null));
                }
            }
            catch (IllegalAccessException iae) {
                e.addSuppressed(iae);
            }
            LinkageError error = new LinkageError("Cannot access sun.misc.Unsafe", e);
            error.addSuppressed(e);
            throw error;
        }
    }
}

