/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.UnsupportedTemporalUnitException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;

public final class LocalDateTimeValue
extends TemporalValue<LocalDateTime, LocalDateTimeValue> {
    private static final long INSTANCE_SIZE = HeapEstimator.shallowSizeOfInstance(LocalDateTimeValue.class) + HeapEstimator.LOCAL_DATE_TIME_SIZE;
    public static final LocalDateTimeValue MIN_VALUE = new LocalDateTimeValue(LocalDateTime.MIN);
    public static final LocalDateTimeValue MAX_VALUE = new LocalDateTimeValue(LocalDateTime.MAX);
    private final LocalDateTime value;
    private final long epochSecondsInUTC;
    private static final LocalDateTime DEFAULT_LOCAL_DATE_TIME = LocalDateTime.of(TemporalValue.TemporalFields.year.defaultValue, TemporalValue.TemporalFields.month.defaultValue, TemporalValue.TemporalFields.day.defaultValue, TemporalValue.TemporalFields.hour.defaultValue, TemporalValue.TemporalFields.minute.defaultValue);
    private static final Pattern PATTERN = Pattern.compile(DateValue.DATE_PATTERN + "(?<time>T(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:[\\.,](?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:[\\.,](?<shortFraction>[0-9]{1,9}))?)?)?)))?", 2);

    private LocalDateTimeValue(LocalDateTime value) {
        this.value = value;
        this.epochSecondsInUTC = this.value.toEpochSecond(ZoneOffset.UTC);
    }

    public static LocalDateTimeValue localDateTime(DateValue date, LocalTimeValue time) {
        return new LocalDateTimeValue(LocalDateTime.of(date.temporal(), time.temporal()));
    }

    public static LocalDateTimeValue localDateTime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond) {
        return new LocalDateTimeValue(LocalDateTimeValue.assertValidArgument(() -> LocalDateTime.of(year, month, day, hour, minute, second, nanoOfSecond)));
    }

    public static LocalDateTimeValue localDateTime(LocalDateTime value) {
        return new LocalDateTimeValue(Objects.requireNonNull(value, "LocalDateTime"));
    }

    public static LocalDateTimeValue localDateTime(long epochSecond, long nano) {
        return new LocalDateTimeValue(LocalDateTimeValue.localDateTimeRaw(epochSecond, nano));
    }

    public static LocalDateTime localDateTimeRaw(long epochSecond, long nano) {
        return LocalDateTimeValue.assertValidArgument(() -> LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nano), ZoneOffset.UTC));
    }

    public static LocalDateTimeValue parse(CharSequence text) {
        return LocalDateTimeValue.parse(LocalDateTimeValue.class, PATTERN, LocalDateTimeValue::parse, text);
    }

    public static LocalDateTimeValue parse(TextValue text) {
        return LocalDateTimeValue.parse(LocalDateTimeValue.class, PATTERN, LocalDateTimeValue::parse, text);
    }

    public static LocalDateTimeValue now(Clock clock) {
        return new LocalDateTimeValue(LocalDateTime.now(clock));
    }

    public static LocalDateTimeValue now(Clock clock, String timezone) {
        return LocalDateTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static LocalDateTimeValue now(Clock clock, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.now(clock.withZone(defaultZone.get()));
    }

    public static LocalDateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return (LocalDateTimeValue)StructureBuilder.build(LocalDateTimeValue.builder(defaultZone), map);
    }

    public static LocalDateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.builder(defaultZone).selectDateTime(from);
    }

    public static LocalDateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        Pair<LocalDate, LocalTime> pair = LocalDateTimeValue.getTruncatedDateAndTime(unit, input, "local date time");
        LocalDate truncatedDate = (LocalDate)pair.first();
        LocalTime truncatedTime = (LocalTime)pair.other();
        LocalDateTime truncatedLDT = LocalDateTime.of(truncatedDate, truncatedTime);
        if (fields.isEmpty()) {
            return LocalDateTimeValue.localDateTime(truncatedLDT);
        }
        return LocalDateTimeValue.updateFieldMapWithConflictingSubseconds(fields, unit, truncatedLDT, (mapValue, localDateTime) -> {
            if (mapValue.isEmpty()) {
                return LocalDateTimeValue.localDateTime(localDateTime);
            }
            return LocalDateTimeValue.build(mapValue.updatedWith("datetime", LocalDateTimeValue.localDateTime(localDateTime)), defaultZone);
        });
    }

    private static DateTimeValue.DateTimeBuilder<LocalDateTimeValue> builder(Supplier<ZoneId> defaultZone) {
        return new DateTimeValue.DateTimeBuilder<LocalDateTimeValue>(defaultZone){

            @Override
            protected boolean supportsTimeZone() {
                return false;
            }

            @Override
            protected boolean supportsEpoch() {
                return false;
            }

            @Override
            public LocalDateTimeValue buildInternal() {
                LocalDateTime result;
                boolean selectingDate = this.fields.containsKey((Object)TemporalValue.TemporalFields.date);
                boolean selectingTime = this.fields.containsKey((Object)TemporalValue.TemporalFields.time);
                boolean selectingDateTime = this.fields.containsKey((Object)TemporalValue.TemporalFields.datetime);
                if (selectingDateTime) {
                    AnyValue dtField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.datetime);
                    if (!(dtField instanceof TemporalValue)) {
                        String string;
                        if (dtField instanceof Value) {
                            Value v = (Value)dtField;
                            string = v.prettyPrint();
                        } else {
                            string = String.valueOf(dtField);
                        }
                        String prettyVal = string;
                        throw InvalidArgumentException.cannotConstructTemporal((String)"local date time", (String)String.valueOf(dtField), (String)prettyVal);
                    }
                    TemporalValue dt = (TemporalValue)dtField;
                    result = LocalDateTime.of(dt.getDatePart(), dt.getLocalTimePart());
                } else if (selectingTime || selectingDate) {
                    LocalDate date;
                    LocalTime time;
                    if (selectingTime) {
                        AnyValue timeField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.time);
                        if (!(timeField instanceof TemporalValue)) {
                            String string;
                            if (timeField instanceof Value) {
                                Value v = (Value)timeField;
                                string = v.prettyPrint();
                            } else {
                                string = String.valueOf(timeField);
                            }
                            String prettyVal = string;
                            throw InvalidArgumentException.cannotConstructTemporal((String)"local time", (String)String.valueOf(timeField), (String)prettyVal);
                        }
                        TemporalValue t = (TemporalValue)timeField;
                        time = t.getLocalTimePart();
                    } else {
                        time = LocalTimeValue.DEFAULT_LOCAL_TIME;
                    }
                    if (selectingDate) {
                        AnyValue dateField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.date);
                        if (!(dateField instanceof TemporalValue)) {
                            String string;
                            if (dateField instanceof Value) {
                                Value v = (Value)dateField;
                                string = v.prettyPrint();
                            } else {
                                string = String.valueOf(dateField);
                            }
                            String prettyVal = string;
                            throw InvalidArgumentException.cannotConstructTemporal((String)"date", (String)String.valueOf(dateField), (String)prettyVal);
                        }
                        TemporalValue t = (TemporalValue)dateField;
                        date = t.getDatePart();
                    } else {
                        date = DateValue.DEFAULT_CALENDER_DATE;
                    }
                    result = LocalDateTime.of(date, time);
                } else {
                    result = DEFAULT_LOCAL_DATE_TIME;
                }
                if (this.fields.containsKey((Object)TemporalValue.TemporalFields.week) && !selectingDate && !selectingDateTime) {
                    result = result.with(IsoFields.WEEK_BASED_YEAR, IntegralValue.safeCastIntegral(TemporalValue.TemporalFields.year.name(), (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.year), TemporalValue.TemporalFields.year.defaultValue)).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1L).with(ChronoField.DAY_OF_WEEK, 1L);
                }
                result = this.assignAllFields(result);
                return LocalDateTimeValue.localDateTime(result);
            }

            private LocalDateTime getLocalDateTimeOf(AnyValue temporal) {
                String string;
                if (temporal instanceof TemporalValue) {
                    TemporalValue v = (TemporalValue)temporal;
                    LocalDate datePart = v.getDatePart();
                    LocalTime timePart = v.getLocalTimePart();
                    return LocalDateTime.of(datePart, timePart);
                }
                if (temporal instanceof Value) {
                    Value v = (Value)temporal;
                    string = v.prettyPrint();
                } else {
                    string = String.valueOf(temporal);
                }
                String prettyVal = string;
                throw InvalidArgumentException.cannotConstructTemporal((String)"date", (String)String.valueOf(temporal), (String)prettyVal);
            }

            @Override
            protected LocalDateTimeValue selectDateTime(AnyValue datetime) {
                if (datetime instanceof LocalDateTimeValue) {
                    return (LocalDateTimeValue)datetime;
                }
                return LocalDateTimeValue.localDateTime(this.getLocalDateTimeOf(datetime));
            }
        };
    }

    @Override
    protected int unsafeCompareTo(Value other) {
        LocalDateTimeValue that = (LocalDateTimeValue)other;
        int cmp = Long.compare(this.epochSecondsInUTC, that.epochSecondsInUTC);
        if (cmp == 0) {
            cmp = this.value.getNano() - that.value.getNano();
        }
        return cmp;
    }

    @Override
    public String getTypeName() {
        return "LocalDateTime";
    }

    @Override
    LocalDateTime temporal() {
        return this.value;
    }

    @Override
    LocalDate getDatePart() {
        return this.value.toLocalDate();
    }

    @Override
    LocalTime getLocalTimePart() {
        return this.value.toLocalTime();
    }

    @Override
    OffsetTime getTimePart(Supplier<ZoneId> defaultZone) {
        ZoneOffset currentOffset = LocalDateTimeValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.now(), (ZoneId)defaultZone.get())).getOffset();
        return OffsetTime.of(this.value.toLocalTime(), currentOffset);
    }

    @Override
    ZoneId getZoneId(Supplier<ZoneId> defaultZone) {
        return defaultZone.get();
    }

    @Override
    ZoneOffset getZoneOffset() {
        throw UnsupportedTemporalUnitException.cannotGetZoneOffset((String)String.valueOf(this));
    }

    @Override
    public boolean supportsTimeZone() {
        return false;
    }

    @Override
    boolean hasTime() {
        return true;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof LocalDateTimeValue && this.value.equals(((LocalDateTimeValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeLocalDateTime(this.value);
    }

    @Override
    public String prettyPrint() {
        return LocalDateTimeValue.assertPrintable(String.valueOf(this.value), () -> this.value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.LOCAL_DATE_TIME;
    }

    @Override
    protected int computeHashToMemoize() {
        return this.value.toInstant(ZoneOffset.UTC).hashCode();
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalDateTime(this);
    }

    public LocalDateTimeValue add(DurationValue duration) {
        return this.replacement(LocalDateTimeValue.assertValidArithmetic(() -> this.value.plus(duration)));
    }

    public LocalDateTimeValue sub(DurationValue duration) {
        return this.replacement(LocalDateTimeValue.assertValidArithmetic(() -> this.value.minus(duration)));
    }

    @Override
    LocalDateTimeValue replacement(LocalDateTime dateTime) {
        return dateTime == this.value ? this : new LocalDateTimeValue(dateTime);
    }

    public long estimatedHeapUsage() {
        return INSTANCE_SIZE;
    }

    private static LocalDateTimeValue parse(Matcher matcher) {
        return LocalDateTimeValue.localDateTime(LocalDateTime.of(DateValue.parseDate(matcher), LocalDateTimeValue.optTime(matcher)));
    }

    static LocalTime optTime(Matcher matcher) {
        return matcher.group("time") != null ? LocalTimeValue.parseTime(matcher) : LocalTime.MIN;
    }
}

