/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Values;

public interface VectorCandidate {
    public float floatValue(int var1);

    public double doubleValue(int var1);

    public int dimensions();

    public static VectorCandidate maybeFrom(AnyValue candidate) {
        if (candidate == null || candidate == Values.NO_VALUE) {
            return null;
        }
        AnyValue anyValue = candidate;
        Objects.requireNonNull(anyValue);
        AnyValue anyValue2 = anyValue;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VectorCandidate.class, SequenceValue.class}, (Object)anyValue2, n)) {
            case 0 -> {
                VectorCandidate vectorCandidate;
                yield vectorCandidate = (VectorCandidate)((Object)anyValue2);
            }
            case 1 -> {
                SequenceValue sequenceValue = (SequenceValue)((Object)anyValue2);
                yield new SequenceValueVectorCandidate(sequenceValue);
            }
            default -> null;
        };
    }

    public record SequenceValueVectorCandidate(SequenceValue sequence) implements VectorCandidate
    {
        @Override
        public float floatValue(int index) {
            float f;
            AnyValue anyValue = this.sequence.value(index);
            if (anyValue instanceof NumberValue) {
                NumberValue number = (NumberValue)anyValue;
                f = number.floatValue();
            } else {
                f = Float.NaN;
            }
            return f;
        }

        @Override
        public double doubleValue(int index) {
            double d;
            AnyValue anyValue = this.sequence.value(index);
            if (anyValue instanceof NumberValue) {
                NumberValue number = (NumberValue)anyValue;
                d = number.doubleValue();
            } else {
                d = Double.NaN;
            }
            return d;
        }

        @Override
        public int dimensions() {
            return this.sequence.intSize();
        }
    }
}

