/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalUtil;

public final class ValueByteBufferCodec {
    public static final ValueType[] VALUE_TYPES = ValueType.values();

    private ValueByteBufferCodec() {
    }

    private static BooleanValue readBoolean(ByteBuffer chunk, int offset) {
        return Values.booleanValue(chunk.get(offset) != 0);
    }

    private static BooleanArray readBooleanArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        boolean[] array = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.get(offset) != 0;
            ++offset;
        }
        return Values.booleanArray(array);
    }

    private static ByteValue readByte(ByteBuffer chunk, int offset) {
        return Values.byteValue(chunk.get(offset));
    }

    private static ByteArray readByteArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.get(offset);
            ++offset;
        }
        return Values.byteArray(array);
    }

    private static CharValue readChar(ByteBuffer chunk, int offset) {
        return Values.charValue(chunk.getChar(offset));
    }

    private static CharArray readCharArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getChar(offset);
            offset += 2;
        }
        return Values.charArray(array);
    }

    private static DateValue readDate(ByteBuffer chunk, int offset) {
        return DateValue.epochDate(chunk.getLong(offset));
    }

    private static ArrayValue readDateArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        LocalDate[] array = new LocalDate[len];
        for (int i = 0; i < len; ++i) {
            array[i] = LocalDate.ofEpochDay(bb.getLong(offset));
            offset += 8;
        }
        return Values.dateArray(array);
    }

    private static DoubleValue readDouble(ByteBuffer chunk, int offset) {
        return Values.doubleValue(chunk.getDouble(offset));
    }

    private static DoubleArray readDoubleArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getDouble(offset);
            offset += 8;
        }
        return Values.doubleArray(array);
    }

    private static DurationValue readDuration(ByteBuffer bb, int offset) {
        long months = bb.getLong(offset);
        long days = bb.getLong(offset += 8);
        long seconds = bb.getLong(offset += 8);
        int nanos = bb.getInt(offset += 8);
        return DurationValue.duration(months, days, seconds, nanos);
    }

    private static ArrayValue readDurationArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        DurationValue[] array = new DurationValue[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ValueByteBufferCodec.readDuration(bb, offset);
            offset += 28;
        }
        return Values.durationArray(array);
    }

    private static FloatValue readFloat(ByteBuffer chunk, int offset) {
        return Values.floatValue(chunk.getFloat(offset));
    }

    private static FloatArray readFloatArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getFloat(offset);
            offset += 4;
        }
        return Values.floatArray(array);
    }

    private static IntValue readInt(ByteBuffer chunk, int offset) {
        return Values.intValue(chunk.getInt(offset));
    }

    private static IntArray readIntArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getInt(offset);
            offset += 4;
        }
        return Values.intArray(array);
    }

    private static LocalDateTimeValue readLocalDateTime(ByteBuffer bb, int offset) {
        long epochSecond = bb.getLong(offset);
        int nanos = bb.getInt(offset += 8);
        return LocalDateTimeValue.localDateTime(epochSecond, nanos);
    }

    private static ArrayValue readLocalDateTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        LocalDateTime[] array = new LocalDateTime[len];
        for (int i = 0; i < len; ++i) {
            long epochSecond = bb.getLong(offset);
            int nanos = bb.getInt(offset += 8);
            offset += 4;
            array[i] = LocalDateTime.ofEpochSecond(epochSecond, nanos, ZoneOffset.UTC);
        }
        return Values.localDateTimeArray(array);
    }

    private static LocalTimeValue readLocalTime(ByteBuffer chunk, int offset) {
        return LocalTimeValue.localTime(chunk.getLong(offset));
    }

    private static ArrayValue readLocalTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        LocalTime[] array = new LocalTime[len];
        for (int i = 0; i < len; ++i) {
            array[i] = LocalTime.ofNanoOfDay(bb.getLong(offset));
            offset += 8;
        }
        return Values.localTimeArray(array);
    }

    private static LongValue readLong(ByteBuffer chunk, int offset) {
        return Values.longValue(chunk.getLong(offset));
    }

    private static LongArray readLongArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        long[] array = new long[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getLong(offset);
            offset += 8;
        }
        return Values.longArray(array);
    }

    private static PointValue readPoint(ByteBuffer chunk, int offset) {
        int crsCode = chunk.getInt(offset);
        offset += 4;
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get(crsCode);
        double[] coordinate = new double[crs.getDimension()];
        for (int i = 0; i < coordinate.length; ++i) {
            coordinate[i] = chunk.getDouble(offset);
            offset += 8;
        }
        return Values.pointValue(crs, coordinate);
    }

    private static PointArray readPointArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        PointValue[] array = new PointValue[len];
        for (int i = 0; i < len; ++i) {
            PointValue point;
            array[i] = point = ValueByteBufferCodec.readPoint(bb, offset);
            offset += 4 + point.getCoordinateReferenceSystem().getDimension() * 8;
        }
        return Values.pointArray(array);
    }

    private static String readRawString(ByteBuffer chunk, int offset) {
        int len = chunk.getInt(offset);
        if (len == 0) {
            return "";
        }
        offset += 4;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = chunk.getChar(offset);
            offset += 2;
        }
        return new String(chars);
    }

    private static ShortValue readShort(ByteBuffer chunk, int offset) {
        return Values.shortValue(chunk.getShort(offset));
    }

    private static ShortArray readShortArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = bb.getShort(offset);
            offset += 2;
        }
        return Values.shortArray(array);
    }

    private static TextValue readString(ByteBuffer chunk, int offset) {
        return Values.stringValue(ValueByteBufferCodec.readRawString(chunk, offset));
    }

    private static ArrayValue readStringArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        String[] array = new String[len];
        for (int i = 0; i < len; ++i) {
            String str;
            array[i] = str = ValueByteBufferCodec.readRawString(bb, offset);
            offset += 4 + str.length() * 2;
        }
        return Values.stringArray(array);
    }

    private static TimeValue readTime(ByteBuffer bb, int offset) {
        return TimeValue.time(ValueByteBufferCodec.readRawTime(bb, offset));
    }

    private static ArrayValue readTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        OffsetTime[] array = new OffsetTime[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ValueByteBufferCodec.readRawTime(bb, offset);
            offset += 12;
        }
        return Values.timeArray(array);
    }

    private static OffsetTime readRawTime(ByteBuffer bb, int offset) {
        long nanosOfDayUTC = bb.getLong(offset);
        int offsetSeconds = bb.getInt(offset += 8);
        return OffsetTime.ofInstant(Instant.ofEpochSecond(0L, nanosOfDayUTC), TimeUtil.zoneOffsetOfTotalSeconds((int)offsetSeconds));
    }

    private static DateTimeValue readDateTime(ByteBuffer bb, int offset) {
        long epocSeconds = bb.getLong(offset);
        int nanos = bb.getInt(offset += 8);
        int z = bb.getInt(offset += 4);
        return DateTimeValue.datetime(epocSeconds, (long)nanos, ValueByteBufferCodec.toZoneId(z));
    }

    private static ZoneId toZoneId(int z) {
        if ((z & 1) != 0) {
            String zoneId = TimeZones.map((short)(z >> 1));
            return ZoneId.of(zoneId);
        }
        return TimeUtil.zoneOffsetOfTotalSeconds((int)(z >> 1));
    }

    private static ArrayValue readDateTimeArray(ByteBuffer bb, int offset) {
        int len = bb.getInt(offset);
        offset += 4;
        ZonedDateTime[] array = new ZonedDateTime[len];
        for (int i = 0; i < len; ++i) {
            long epocSeconds = bb.getLong(offset);
            int nanos = bb.getInt(offset += 8);
            int z = bb.getInt(offset += 4);
            offset += 4;
            array[i] = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epocSeconds, nanos), ValueByteBufferCodec.toZoneId(z));
        }
        return Values.dateTimeArray(array);
    }

    public static Value readValue(ByteBuffer buffer) {
        byte valueTypeOrdinal = buffer.get();
        ValueType type = VALUE_TYPES[valueTypeOrdinal];
        return type.getReader().read(buffer, buffer.position());
    }

    public static enum ValueType {
        NO_VALUE(NoValue.class, (unused, unused2) -> Values.NO_VALUE),
        BOOLEAN(BooleanValue.class, ValueByteBufferCodec::readBoolean),
        BOOLEAN_ARRAY(BooleanArray.class, ValueByteBufferCodec::readBooleanArray),
        BYTE(ByteValue.class, ValueByteBufferCodec::readByte),
        BYTE_ARRAY(ByteArray.class, ValueByteBufferCodec::readByteArray),
        SHORT(ShortValue.class, ValueByteBufferCodec::readShort),
        SHORT_ARRAY(ShortArray.class, ValueByteBufferCodec::readShortArray),
        INT(IntValue.class, ValueByteBufferCodec::readInt),
        INT_ARRAY(IntArray.class, ValueByteBufferCodec::readIntArray),
        LONG(LongValue.class, ValueByteBufferCodec::readLong),
        LONG_ARRAY(LongArray.class, ValueByteBufferCodec::readLongArray),
        FLOAT(FloatValue.class, ValueByteBufferCodec::readFloat),
        FLOAT_ARRAY(FloatArray.class, ValueByteBufferCodec::readFloatArray),
        DOUBLE(DoubleValue.class, ValueByteBufferCodec::readDouble),
        DOUBLE_ARRAY(DoubleArray.class, ValueByteBufferCodec::readDoubleArray),
        STRING(StringValue.class, ValueByteBufferCodec::readString),
        STRING_ARRAY(StringArray.class, ValueByteBufferCodec::readStringArray),
        CHAR(CharValue.class, ValueByteBufferCodec::readChar),
        CHAR_ARRAY(CharArray.class, ValueByteBufferCodec::readCharArray),
        POINT(PointValue.class, ValueByteBufferCodec::readPoint),
        POINT_ARRAY(PointArray.class, ValueByteBufferCodec::readPointArray),
        DURATION(DurationValue.class, ValueByteBufferCodec::readDuration),
        DURATION_ARRAY(DurationArray.class, ValueByteBufferCodec::readDurationArray),
        DATE(DateValue.class, ValueByteBufferCodec::readDate),
        DATE_ARRAY(DateArray.class, ValueByteBufferCodec::readDateArray),
        TIME(TimeValue.class, ValueByteBufferCodec::readTime),
        TIME_ARRAY(TimeArray.class, ValueByteBufferCodec::readTimeArray),
        DATE_TIME(DateTimeValue.class, ValueByteBufferCodec::readDateTime),
        DATE_TIME_ARRAY(DateTimeArray.class, ValueByteBufferCodec::readDateTimeArray),
        LOCAL_TIME(LocalTimeValue.class, ValueByteBufferCodec::readLocalTime),
        LOCAL_TIME_ARRAY(LocalTimeArray.class, ValueByteBufferCodec::readLocalTimeArray),
        LOCAL_DATE_TIME(LocalDateTimeValue.class, ValueByteBufferCodec::readLocalDateTime),
        LOCAL_DATE_TIME_ARRAY(LocalDateTimeArray.class, ValueByteBufferCodec::readLocalDateTimeArray);

        private final Class<?> valueClass;
        private final ValueReader reader;

        private <T extends Value> ValueType(Class<? extends T> valueClass, ValueReader<T> reader) {
            this.valueClass = valueClass;
            this.reader = reader;
        }

        private static ValueType forValue(Value value) {
            for (ValueType valueType : VALUE_TYPES) {
                if (!valueType.valueClass.isAssignableFrom(value.getClass())) continue;
                return valueType;
            }
            throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(value.getClass()));
        }

        public ValueReader getReader() {
            return this.reader;
        }
    }

    @FunctionalInterface
    public static interface ValueReader<T extends Value> {
        public T read(ByteBuffer var1, int var2);
    }

    public static class Writer
    implements ValueWriter<RuntimeException>,
    Resource {
        private final ByteBufferAllocator allocation;
        private ByteBuffer buf;

        public Writer(int chunkSize, ByteBufferAllocator allocation) {
            this.allocation = allocation;
            this.buf = allocation.allocate(chunkSize);
        }

        public void close() {
            this.allocation.free();
            this.buf = null;
        }

        public ByteBuffer write(Value value) {
            Preconditions.checkState((this.buf != null ? 1 : 0) != 0, (String)"Writer is closed");
            try {
                this.buf.clear();
                this.buf.put((byte)ValueType.forValue(value).ordinal());
                value.writeTo(this);
                this.buf.flip();
                return this.buf;
            }
            catch (BufferOverflowException e) {
                int newSize = this.newSizeGrow();
                this.allocation.free();
                this.buf = this.allocation.allocate(newSize);
                return this.write(value);
            }
        }

        private int newSizeGrow() {
            long old = this.buf.capacity();
            if (old == 0x7FFFFFF7L) {
                throw new RuntimeException("Unable to allocate array bigger than 2147483639");
            }
            return Math.toIntExact(Math.min(old * 2L, 0x7FFFFFF7L));
        }

        @Override
        public void writeNull() {
        }

        @Override
        public void writeBoolean(boolean value) {
            this.buf.put((byte)(value ? 1 : 0));
        }

        @Override
        public void writeInteger(byte value) {
            this.buf.put(value);
        }

        @Override
        public void writeInteger(short value) {
            this.buf.putShort(value);
        }

        @Override
        public void writeInteger(int value) {
            this.buf.putInt(value);
        }

        @Override
        public void writeInteger(long value) {
            this.buf.putLong(value);
        }

        @Override
        public void writeFloatingPoint(float value) {
            this.buf.putFloat(value);
        }

        @Override
        public void writeFloatingPoint(double value) {
            this.buf.putDouble(value);
        }

        @Override
        public void writeString(String value) {
            int len = value.length();
            this.buf.putInt(value.length());
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                this.buf.putChar(c);
            }
        }

        @Override
        public void writeString(char value) {
            this.buf.putChar(value);
        }

        @Override
        public void beginArray(int size, ValueWriter.ArrayType arrayType) {
            this.buf.putInt(size);
        }

        @Override
        public void endArray() {
        }

        @Override
        public void writeByteArray(byte[] value) {
            this.buf.putInt(value.length);
            this.buf.put(value);
        }

        @Override
        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
            Preconditions.checkArgument((coordinate.length == crs.getDimension() ? 1 : 0) != 0, (String)"Dimension for %s is %d, got %d", (Object[])new Object[]{crs.getName(), crs.getDimension(), coordinate.length});
            this.buf.putInt(crs.getCode());
            for (int i = 0; i < crs.getDimension(); ++i) {
                this.buf.putDouble(coordinate[i]);
            }
        }

        @Override
        public void writeDuration(long months, long days, long seconds, int nanos) {
            this.buf.putLong(months);
            this.buf.putLong(days);
            this.buf.putLong(seconds);
            this.buf.putInt(nanos);
        }

        @Override
        public void writeDate(LocalDate localDate) {
            this.buf.putLong(localDate.toEpochDay());
        }

        @Override
        public void writeLocalTime(LocalTime localTime) {
            this.buf.putLong(localTime.toNanoOfDay());
        }

        @Override
        public void writeTime(OffsetTime offsetTime) {
            this.buf.putLong(TemporalUtil.getNanosOfDayUTC(offsetTime));
            this.buf.putInt(offsetTime.getOffset().getTotalSeconds());
        }

        @Override
        public void writeLocalDateTime(LocalDateTime localDateTime) {
            this.buf.putLong(localDateTime.toEpochSecond(ZoneOffset.UTC));
            this.buf.putInt(localDateTime.getNano());
        }

        @Override
        public void writeDateTime(ZonedDateTime zonedDateTime) {
            this.buf.putLong(zonedDateTime.toEpochSecond());
            this.buf.putInt(zonedDateTime.getNano());
            ZoneId zone = zonedDateTime.getZone();
            if (zone instanceof ZoneOffset) {
                int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
                this.buf.putInt(offsetSeconds << 1);
            } else {
                int zoneId = TimeZones.map(zone.getId()) << 1 | 1;
                this.buf.putInt(zoneId);
            }
        }

        @Override
        public void writeInt8Vector(byte[] values) throws RuntimeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeInt16Vector(short[] values) throws RuntimeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeInt32Vector(int[] values) throws RuntimeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeInt64Vector(long[] values) throws RuntimeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeFloat32Vector(float[] values) throws RuntimeException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeFloat64Vector(double[] values) throws RuntimeException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ByteBufferAllocator {
        public ByteBuffer allocate(long var1);

        public void free();
    }
}

