/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.FloatingPointVector;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Vector;

public final class Float64Vector
extends FloatingPointVector {
    public static final String NESTED_TYPE_NAME = "FLOAT64";
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Float64Vector.class);
    private final double[] coordinates;

    Float64Vector(double ... coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public float floatValue(int index) {
        return (float)this.coordinates[index];
    }

    @Override
    public double doubleValue(int index) {
        return this.coordinates[index];
    }

    @Override
    public int dimensions() {
        return this.coordinates.length;
    }

    @Override
    public String getTypeName() {
        return "Float64Vector";
    }

    @Override
    public Vector.CoordinateType coordinateType() {
        return Vector.CoordinateType.FLOAT64;
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.FLOAT64_VECTOR;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof Float64Vector) {
            Float64Vector v = (Float64Vector)other;
            return Arrays.equals(this.coordinates, v.coordinates);
        }
        return false;
    }

    @Override
    protected int unsafeCompareTo(Value other) {
        Float64Vector that = (Float64Vector)other;
        int comparison = Integer.compare(this.dimensions(), that.dimensions());
        if (comparison != 0) {
            return comparison;
        }
        return Arrays.compare(this.coordinates, that.coordinates);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeFloat64Vector(this.coordinates);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapFloat64Vector(this);
    }

    @Override
    protected long longBits(int i) {
        return Double.doubleToLongBits(this.coordinates[i]);
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.coordinates);
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((double[])this.coordinates);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.coordinates));
    }
}

