/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public final class MapValue
extends VirtualValue {
    private final Map<String, AnyValue> map;

    MapValue(Map<String, AnyValue> map) {
        this.map = map;
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || other.getClass() != MapValue.class) {
            return false;
        }
        MapValue that = (MapValue)other;
        return this.map.equals(that.map);
    }

    @Override
    public int computeHash() {
        return this.map.hashCode();
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.beginMap(this.map.size());
        for (Map.Entry<String, AnyValue> entry : this.map.entrySet()) {
            writer.writeString(entry.getKey());
            entry.getValue().writeTo(writer);
        }
        writer.endMap();
    }

    public ListValue keys() {
        String[] strings = this.keySet().toArray(new String[this.map.size()]);
        return VirtualValues.fromArray(Values.stringArray(strings));
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.MAP;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other == null || other.getClass() != MapValue.class) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        Map<String, AnyValue> otherMap = ((MapValue)other).map;
        int size = this.map.size();
        int compare = Integer.compare(this.size(), otherMap.size());
        if (compare == 0) {
            int i;
            String[] thisKeys = this.keySet().toArray(new String[size]);
            Arrays.sort(thisKeys, String::compareTo);
            String[] thatKeys = otherMap.keySet().toArray(new String[size]);
            Arrays.sort(thatKeys, String::compareTo);
            for (i = 0; i < size; ++i) {
                compare = thisKeys[i].compareTo(thatKeys[i]);
                if (compare == 0) continue;
                return compare;
            }
            for (i = 0; i < size; ++i) {
                String key = thisKeys[i];
                compare = comparator.compare(this.map.get(key), otherMap.get(key));
                if (compare == 0) continue;
                return compare;
            }
        }
        return compare;
    }

    @Override
    public Boolean ternaryEquals(AnyValue other) {
        if (other == null || other == Values.NO_VALUE) {
            return null;
        }
        if (!(other instanceof MapValue)) {
            return Boolean.FALSE;
        }
        Map<String, AnyValue> otherMap = ((MapValue)other).map;
        int size = this.map.size();
        if (size != otherMap.size()) {
            return Boolean.FALSE;
        }
        String[] thisKeys = this.keySet().toArray(new String[size]);
        Arrays.sort(thisKeys, String::compareTo);
        String[] thatKeys = otherMap.keySet().toArray(new String[size]);
        Arrays.sort(thatKeys, String::compareTo);
        for (int i = 0; i < size; ++i) {
            if (thisKeys[i].compareTo(thatKeys[i]) == 0) continue;
            return Boolean.FALSE;
        }
        Boolean equalityResult = Boolean.TRUE;
        for (int i = 0; i < size; ++i) {
            String key = thisKeys[i];
            Boolean s = this.map.get(key).ternaryEquals(otherMap.get(key));
            if (s == null) {
                equalityResult = null;
                continue;
            }
            if (s.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return equalityResult;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapMap(this);
    }

    @Override
    public String getTypeName() {
        return "Map";
    }

    public void foreach(BiConsumer<String, AnyValue> f) {
        this.map.forEach(f);
    }

    public Set<Map.Entry<String, AnyValue>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public AnyValue get(String key) {
        return this.map.getOrDefault(key, Values.NO_VALUE);
    }

    public Map<String, AnyValue> getMapCopy() {
        return new HashMap<String, AnyValue>(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
        String sep = "";
        for (Map.Entry<String, AnyValue> entry : this.map.entrySet()) {
            sb.append(sep);
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue());
            sep = ", ";
        }
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.map.size();
    }
}

