/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Comparison;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;

public abstract class Value
extends AnyValue {
    static final Pattern mapPattern = Pattern.compile("\\{(.*)\\}");
    static final Pattern keyValuePattern = Pattern.compile("(?:\\A|,)\\s*+(?<k>[a-z_A-Z]\\w*+)\\s*:\\s*(?<v>[^\\s,]+)");
    static final Pattern quotesPattern = Pattern.compile("^[\"']|[\"']$");

    @Override
    public boolean eq(Object other) {
        return other instanceof Value && this.equals((Value)other);
    }

    public abstract boolean equals(Value var1);

    public boolean equals(byte[] x) {
        return false;
    }

    public boolean equals(short[] x) {
        return false;
    }

    public boolean equals(int[] x) {
        return false;
    }

    public boolean equals(long[] x) {
        return false;
    }

    public boolean equals(float[] x) {
        return false;
    }

    public boolean equals(double[] x) {
        return false;
    }

    public boolean equals(boolean x) {
        return false;
    }

    public boolean equals(boolean[] x) {
        return false;
    }

    public boolean equals(long x) {
        return false;
    }

    public boolean equals(double x) {
        return false;
    }

    public boolean equals(char x) {
        return false;
    }

    public boolean equals(String x) {
        return false;
    }

    public boolean equals(char[] x) {
        return false;
    }

    public boolean equals(String[] x) {
        return false;
    }

    public boolean equals(Geometry[] x) {
        return false;
    }

    public boolean equals(ZonedDateTime[] x) {
        return false;
    }

    public boolean equals(LocalDate[] x) {
        return false;
    }

    public boolean equals(DurationValue[] x) {
        return false;
    }

    public boolean equals(LocalDateTime[] x) {
        return false;
    }

    public boolean equals(LocalTime[] x) {
        return false;
    }

    public boolean equals(OffsetTime[] x) {
        return false;
    }

    @Override
    public Boolean ternaryEquals(AnyValue other) {
        if (other == null || other == Values.NO_VALUE) {
            return null;
        }
        if (other.isSequenceValue() && this.isSequenceValue()) {
            return ((SequenceValue)((Object)this)).ternaryEquality((SequenceValue)((Object)other));
        }
        if (other instanceof Value && ((Value)other).valueGroup() == this.valueGroup()) {
            Value otherValue = (Value)other;
            if (this.isNaN() || otherValue.isNaN()) {
                return null;
            }
            return this.equals(otherValue);
        }
        return Boolean.FALSE;
    }

    abstract int unsafeCompareTo(Value var1);

    Comparison unsafeTernaryCompareTo(Value other) {
        return Comparison.from(this.unsafeCompareTo(other));
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        this.writeTo((ValueWriter<E>)writer);
    }

    public abstract <E extends Exception> void writeTo(ValueWriter<E> var1) throws E;

    public abstract Object asObjectCopy();

    public Object asObject() {
        return this.asObjectCopy();
    }

    public abstract String prettyPrint();

    public abstract ValueGroup valueGroup();

    public abstract NumberType numberType();

    public final long hashCode64() {
        HashFunction xxh64 = HashFunction.incrementalXXH64();
        long seed = 1L;
        return xxh64.finalise(this.updateHash(xxh64, xxh64.initialise(seed)));
    }

    public abstract long updateHash(HashFunction var1, long var2);

    public boolean isNaN() {
        return false;
    }

    static void parseHeaderInformation(CharSequence text, String type, CSVHeaderInformation info) {
        Matcher mapMatcher = mapPattern.matcher(text);
        String errorMessage = String.format("Failed to parse %s value: '%s'", type, text);
        if (!mapMatcher.find() || mapMatcher.groupCount() != 1) {
            throw new InvalidValuesArgumentException(errorMessage);
        }
        String mapContents = mapMatcher.group(1);
        if (mapContents.isEmpty()) {
            throw new InvalidValuesArgumentException(errorMessage);
        }
        Matcher matcher = keyValuePattern.matcher(mapContents);
        if (!matcher.find()) {
            throw new InvalidValuesArgumentException(errorMessage);
        }
        do {
            String value;
            String key;
            if ((key = matcher.group("k")) == null || (value = matcher.group("v")) == null) continue;
            info.assign(key, value);
        } while (matcher.find());
    }

    public abstract String getTypeName();
}

