/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeZones {
    private static final List<String> TIME_ZONE_SHORT_TO_STRING = new ArrayList<String>(1024);
    private static final Map<String, Short> TIME_ZONE_STRING_TO_SHORT = new HashMap<String, Short>(1024);
    private static final long MIN_ZONE_OFFSET_SECONDS = -64800L;
    private static final long MAX_ZONE_OFFSET_SECONDS = 64800L;
    public static final String LATEST_SUPPORTED_IANA_VERSION;

    private TimeZones() {
    }

    public static boolean validZoneOffset(int zoneOffsetSeconds) {
        return (long)zoneOffsetSeconds >= -64800L && (long)zoneOffsetSeconds <= 64800L;
    }

    public static boolean validZoneId(short zoneId) {
        return zoneId >= 0 && zoneId < TIME_ZONE_SHORT_TO_STRING.size();
    }

    public static short map(String tzid) {
        if (!TIME_ZONE_STRING_TO_SHORT.containsKey(tzid)) {
            throw new IllegalArgumentException("tzid");
        }
        return TIME_ZONE_STRING_TO_SHORT.get(tzid);
    }

    public static String map(short offset) {
        return TIME_ZONE_SHORT_TO_STRING.get(offset);
    }

    public static Set<String> supportedTimeZones() {
        return Collections.unmodifiableSet(TIME_ZONE_STRING_TO_SHORT.keySet());
    }

    static {
        String latestVersion = "";
        Pattern version = Pattern.compile("# tzdata([0-9]{4}[a-z])");
        HashMap<String, String> oldToNewName = new HashMap<String, String>(1024);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(TimeZones.class.getResourceAsStream("/TZIDS")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//") || line.trim().isEmpty()) continue;
                if (line.startsWith("#")) {
                    Matcher matcher = version.matcher(line);
                    if (!matcher.matches()) continue;
                    latestVersion = matcher.group(1);
                    continue;
                }
                int sep = line.indexOf(32);
                if (sep != -1) {
                    String oldName = line.substring(0, sep);
                    String newName = line.substring(sep + 1);
                    TIME_ZONE_SHORT_TO_STRING.add(newName);
                    oldToNewName.put(oldName, newName);
                    continue;
                }
                TIME_ZONE_SHORT_TO_STRING.add(line);
                TIME_ZONE_STRING_TO_SHORT.put(line, (short)(TIME_ZONE_SHORT_TO_STRING.size() - 1));
            }
            LATEST_SUPPORTED_IANA_VERSION = latestVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read time zone id file.");
        }
        for (Map.Entry entry : oldToNewName.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = (String)entry.getValue();
            Short newNameId = TIME_ZONE_STRING_TO_SHORT.get(newName);
            TIME_ZONE_STRING_TO_SHORT.put(oldName, newNameId);
        }
    }
}

