/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.ValueWriter;

public final class FloatValue
extends FloatingPointValue {
    private final float value;

    FloatValue(float value) {
        this.value = value;
    }

    public float value() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeFloatingPoint(this.value);
    }

    @Override
    public Float asObjectCopy() {
        return Float.valueOf(this.value);
    }

    @Override
    public String prettyPrint() {
        return Float.toString(this.value);
    }

    public String toString() {
        return String.format("%s(%e)", this.getTypeName(), Float.valueOf(this.value));
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapFloat(this);
    }

    @Override
    public String getTypeName() {
        return "Float";
    }
}

