/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.NonPrimitiveArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class PointArray
extends NonPrimitiveArray<PointValue> {
    private final PointValue[] value;

    PointArray(PointValue[] value) {
        assert (value != null);
        this.value = value;
    }

    protected PointValue[] value() {
        return this.value;
    }

    public PointValue pointValue(int offset) {
        return this.value()[offset];
    }

    @Override
    public boolean equals(Geometry[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof PointArray && Arrays.equals(this.value(), ((PointArray)other).value());
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.GEOMETRY_ARRAY;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPointArray(this);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public AnyValue value(int offset) {
        return Values.point(this.value[offset]);
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((PointArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "PointArray";
    }

    @Override
    long sizePerItem() {
        return 60L;
    }
}

