/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public abstract class RelationshipValue
extends VirtualRelationshipValue {
    private final long id;
    private static final long DIRECT_RELATIONSHIP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DirectRelationshipValue.class);

    protected RelationshipValue(long id) {
        this.id = id;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeRelationshipReference(this.id);
        } else {
            writer.writeRelationship(this.id, this.startNode().id(), this.endNode().id(), this.type(), this.properties());
        }
    }

    public String toString() {
        return String.format("-[%d]-", this.id);
    }

    public abstract NodeValue startNode();

    public abstract NodeValue endNode();

    @Override
    public long id() {
        return this.id;
    }

    public abstract TextValue type();

    public abstract MapValue properties();

    public NodeValue otherNode(VirtualNodeValue node) {
        return node.equals(this.startNode()) ? this.endNode() : this.startNode();
    }

    public long otherNodeId(long node) {
        return node == this.startNode().id() ? this.endNode().id() : this.startNode().id();
    }

    @Override
    public String getTypeName() {
        return "Relationship";
    }

    static class DirectRelationshipValue
    extends RelationshipValue {
        private final NodeValue startNode;
        private final NodeValue endNode;
        private final TextValue type;
        private final MapValue properties;

        DirectRelationshipValue(long id, NodeValue startNode, NodeValue endNode, TextValue type, MapValue properties) {
            super(id);
            assert (properties != null);
            this.startNode = startNode;
            this.endNode = endNode;
            this.type = type;
            this.properties = properties;
        }

        @Override
        public NodeValue startNode() {
            return this.startNode;
        }

        @Override
        public NodeValue endNode() {
            return this.endNode;
        }

        @Override
        public TextValue type() {
            return this.type;
        }

        @Override
        public MapValue properties() {
            return this.properties;
        }

        public long estimatedHeapUsage() {
            return DIRECT_RELATIONSHIP_VALUE_SHALLOW_SIZE + this.startNode.estimatedHeapUsage() + this.endNode.estimatedHeapUsage() + this.type.estimatedHeapUsage() + this.properties.estimatedHeapUsage();
        }
    }
}

