/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.ListValue;

public class HeapTrackingListValueBuilder
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingListValueBuilder.class);
    private final HeapTrackingArrayList<AnyValue> values;
    private final MemoryTracker scopedMemoryTracker;

    public static HeapTrackingListValueBuilder newHeapTrackingListBuilder(MemoryTracker memoryTracker) {
        return new HeapTrackingListValueBuilder(memoryTracker);
    }

    public HeapTrackingListValueBuilder(MemoryTracker memoryTracker) {
        this.scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        this.scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        this.values = HeapTrackingArrayList.newArrayList((int)16, (MemoryTracker)this.scopedMemoryTracker);
    }

    public void add(AnyValue value) {
        this.scopedMemoryTracker.allocateHeap(value.estimatedHeapUsage());
        this.values.add((Object)value);
    }

    public ListValue build() {
        return new ListValue.JavaListListValue((List<AnyValue>)this.values, this.payloadSize());
    }

    public ListValue buildAndClose() {
        ListValue value = this.build();
        this.close();
        return value;
    }

    public HeapTrackingListValueBuilder combine(HeapTrackingListValueBuilder rhs) {
        this.values.addAll(rhs.values);
        this.scopedMemoryTracker.allocateHeap(rhs.payloadSize());
        return this;
    }

    private long payloadSize() {
        return this.scopedMemoryTracker.estimatedHeapMemory() - SHALLOW_SIZE;
    }

    @Override
    public void close() {
        this.scopedMemoryTracker.close();
    }

    public static Collector<AnyValue, HeapTrackingListValueBuilder, ListValue> collector(final MemoryTracker memoryTracker) {
        return new Collector<AnyValue, HeapTrackingListValueBuilder, ListValue>(){

            @Override
            public Supplier<HeapTrackingListValueBuilder> supplier() {
                return () -> HeapTrackingListValueBuilder.newHeapTrackingListBuilder(memoryTracker);
            }

            @Override
            public BiConsumer<HeapTrackingListValueBuilder, AnyValue> accumulator() {
                return HeapTrackingListValueBuilder::add;
            }

            @Override
            public BinaryOperator<HeapTrackingListValueBuilder> combiner() {
                return HeapTrackingListValueBuilder::combine;
            }

            @Override
            public Function<HeapTrackingListValueBuilder, ListValue> finisher() {
                return HeapTrackingListValueBuilder::buildAndClose;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.emptySet();
            }
        };
    }
}

