/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.exceptions.IncomparableValuesException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.CompositeDatabaseValue;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualNodeValue
extends VirtualValue {
    public abstract long id();

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        VirtualNodeValue otherNode = (VirtualNodeValue)other;
        return Long.compare(this.id(), otherNode.id());
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        return Comparison.from(this.unsafeCompareTo(other, comparator));
    }

    @Override
    protected int computeHashToMemoize() {
        return Long.hashCode(this.id());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapNode(this);
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualNodeValue)) {
            return false;
        }
        VirtualNodeValue that = (VirtualNodeValue)other;
        if (!(this instanceof VirtualNodeReference) && other instanceof CompositeDatabaseValue) {
            throw new IncomparableValuesException(this.getClass().getSimpleName(), other.getClass().getSimpleName());
        }
        return this.id() == that.id();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.NODE;
    }
}

