/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NonPrimitiveArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class DurationArray
extends NonPrimitiveArray<DurationValue> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DurationArray.class);
    private final DurationValue[] value;

    DurationArray(DurationValue[] value) {
        assert (value != null);
        this.value = value;
    }

    protected DurationValue[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDurationArray(this);
    }

    @Override
    public boolean equals(SequenceValue other) {
        if (other instanceof ArrayValue) {
            ArrayValue otherArray = (ArrayValue)other;
            return otherArray.equals(this.value);
        }
        return super.equals(other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(DurationValue[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.beginArray(this.value.length, ValueWriter.ArrayType.DURATION);
        for (DurationValue x : this.value) {
            x.writeTo(writer);
        }
        writer.endArray();
    }

    @Override
    public AnyValue value(int offset) {
        return Values.durationValue(this.value[offset]);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.DURATION_ARRAY;
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DurationArray)otherValue);
    }

    @Override
    public boolean isIncomparableType() {
        return true;
    }

    @Override
    public String getTypeName() {
        return "DurationArray";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray((long)DurationValue.SHALLOW_SIZE, (int)this.value.length);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof DurationValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        DurationValue[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = (DurationValue)added;
        return new DurationArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        DurationValue[] newArray = new DurationValue[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = (DurationValue)prepended;
        return new DurationArray(newArray);
    }
}

