/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public abstract class CRSCalculator {
    public abstract double distance(PointValue var1, PointValue var2);

    public abstract List<Pair<PointValue, PointValue>> boundingBox(PointValue var1, double var2);

    public boolean withinBBox(PointValue point, PointValue lowerLeft, PointValue upperRight) {
        return this.withinBBox(point, lowerLeft, upperRight, true);
    }

    public abstract boolean withinBBox(PointValue var1, PointValue var2, PointValue var3, boolean var4);

    public abstract List<Pair<PointValue, PointValue>> computeBBoxes(PointValue var1, PointValue var2);

    protected static double pythagoras(double[] a, double[] b) {
        double sqrSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double diff = a[i] - b[i];
            sqrSum += diff * diff;
        }
        return Math.sqrt(sqrSum);
    }

    public static class GeographicCalculator
    extends CRSCalculator {
        public static final double EARTH_RADIUS_METERS = 6378140.0;
        private static final double EXTENSION_FACTOR = 1.0001;
        int dimension;

        GeographicCalculator(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public double distance(PointValue p1, PointValue p2) {
            assert (p1.getCoordinateReferenceSystem().getDimension() == this.dimension);
            assert (p2.getCoordinateReferenceSystem().getDimension() == this.dimension);
            double[] c1Coord = p1.coordinate();
            double[] c2Coord = p2.coordinate();
            double[] c1 = new double[]{Math.toRadians(c1Coord[0]), Math.toRadians(c1Coord[1])};
            double[] c2 = new double[]{Math.toRadians(c2Coord[0]), Math.toRadians(c2Coord[1])};
            double dx = c2[0] - c1[0];
            double dy = c2[1] - c1[1];
            double alpha = Math.pow(Math.sin(dy / 2.0), 2.0) + Math.cos(c1[1]) * Math.cos(c2[1]) * Math.pow(Math.sin(dx / 2.0), 2.0);
            double greatCircleDistance = 2.0 * Math.atan2(Math.sqrt(alpha), Math.sqrt(1.0 - alpha));
            if (this.dimension == 2) {
                return 6378140.0 * greatCircleDistance;
            }
            if (this.dimension == 3) {
                double avgHeight = (p1.coordinate()[2] + p2.coordinate()[2]) / 2.0;
                double distance2D = (6378140.0 + avgHeight) * greatCircleDistance;
                double[] a = new double[this.dimension - 1];
                double[] b = new double[this.dimension - 1];
                a[0] = distance2D;
                b[0] = 0.0;
                for (int i = 1; i < this.dimension - 1; ++i) {
                    a[i] = 0.0;
                    b[i] = c1Coord[i + 1] - c2Coord[i + 1];
                }
                return GeographicCalculator.pythagoras(a, b);
            }
            throw new UnsupportedOperationException("More than 3 dimensions are not supported for distance calculations.");
        }

        @Override
        public List<Pair<PointValue, PointValue>> boundingBox(PointValue center, double distance) {
            if (distance == 0.0) {
                return Collections.singletonList(Pair.of((Object)center, (Object)center));
            }
            double extendedDistance = distance * 1.0001;
            double lat = center.coordinate()[1];
            double lon = center.coordinate()[0];
            double r = extendedDistance / 6378140.0;
            double latMin = lat - Math.toDegrees(r);
            double latMax = lat + Math.toDegrees(r);
            if (latMax >= 90.0 && latMin <= -90.0) {
                return Collections.singletonList(GeographicCalculator.boundingBoxOf(-180.0, 180.0, -90.0, 90.0, center, distance));
            }
            if (latMax >= 90.0) {
                return Collections.singletonList(GeographicCalculator.boundingBoxOf(-180.0, 180.0, latMin, 90.0, center, distance));
            }
            if (latMin <= -90.0) {
                return Collections.singletonList(GeographicCalculator.boundingBoxOf(-180.0, 180.0, -90.0, latMax, center, distance));
            }
            double deltaLon = Math.toDegrees(Math.asin(Math.sin(r) / Math.cos(Math.toRadians(lat))));
            double lonMin = lon - deltaLon;
            double lonMax = lon + deltaLon;
            if (lonMin < -180.0 && lonMax > 180.0) {
                return Collections.singletonList(GeographicCalculator.boundingBoxOf(-180.0, 180.0, latMin, latMax, center, distance));
            }
            if (lonMin < -180.0) {
                Pair<PointValue, PointValue> box1 = GeographicCalculator.boundingBoxOf(lonMin + 360.0, 180.0, latMin, latMax, center, distance);
                Pair<PointValue, PointValue> box2 = GeographicCalculator.boundingBoxOf(-180.0, lonMax, latMin, latMax, center, distance);
                return Arrays.asList(box1, box2);
            }
            if (lonMax > 180.0) {
                Pair<PointValue, PointValue> box1 = GeographicCalculator.boundingBoxOf(lonMin, 180.0, latMin, latMax, center, distance);
                Pair<PointValue, PointValue> box2 = GeographicCalculator.boundingBoxOf(-180.0, lonMax - 360.0, latMin, latMax, center, distance);
                return Arrays.asList(box1, box2);
            }
            return Collections.singletonList(GeographicCalculator.boundingBoxOf(lonMin, lonMax, latMin, latMax, center, distance));
        }

        @Override
        public List<Pair<PointValue, PointValue>> computeBBoxes(PointValue lowerLeft, PointValue upperRight) {
            double[] ur;
            assert (lowerLeft.getCoordinateReferenceSystem().equals((Object)upperRight.getCoordinateReferenceSystem()));
            double[] ll = lowerLeft.coordinate();
            if (ll[0] <= (ur = upperRight.coordinate())[0]) {
                return List.of(Pair.of((Object)lowerLeft, (Object)upperRight));
            }
            if (ll[0] >= 0.0 && ur[0] < 0.0) {
                return List.of(Pair.of((Object)lowerLeft, (Object)this.withLongitude(180.0, upperRight)), Pair.of((Object)this.withLongitude(-180.0, lowerLeft), (Object)upperRight));
            }
            return List.of(Pair.of((Object)this.withLongitude(-180.0, lowerLeft), (Object)upperRight), Pair.of((Object)lowerLeft, (Object)this.withLongitude(180.0, upperRight)));
        }

        @Override
        public boolean withinBBox(PointValue point, PointValue lowerLeft, PointValue upperRight, boolean inclusive) {
            int i;
            double[] ur;
            if (lowerLeft == null && upperRight == null) {
                return true;
            }
            double[] check = point.coordinate();
            if (upperRight == null) {
                int i2;
                double[] ll = lowerLeft.coordinate();
                for (i2 = 0; i2 < 2; ++i2) {
                    if (!(inclusive && check[i2] < ll[i2]) && (inclusive || !(check[i2] <= ll[i2]))) continue;
                    return false;
                }
                while (i2 < check.length) {
                    if (inclusive && check[i2] < ll[i2] || !inclusive && check[i2] <= ll[i2]) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            if (lowerLeft == null) {
                int i3;
                double[] ur2 = upperRight.coordinate();
                for (i3 = 0; i3 < 2; ++i3) {
                    if (!(inclusive && check[i3] > ur2[i3]) && (inclusive || !(check[i3] >= ur2[i3]))) continue;
                    return false;
                }
                while (i3 < check.length) {
                    if (inclusive && check[i3] > ur2[i3] || !inclusive && check[i3] >= ur2[i3]) {
                        return false;
                    }
                    ++i3;
                }
                return true;
            }
            double[] ll = lowerLeft.coordinate();
            if (this.isNorthOf(ll, ur = upperRight.coordinate())) {
                return false;
            }
            for (i = 0; i < 2; ++i) {
                if (!(ll[i] <= ur[i] ? inclusive && (check[i] < ll[i] || check[i] > ur[i]) || !inclusive && (check[i] <= ll[i] || check[i] >= ur[i]) : inclusive && check[i] > ur[i] && check[i] < ll[i] || !inclusive && check[i] >= ur[i] && check[i] <= ll[i])) continue;
                return false;
            }
            while (i < check.length) {
                if (inclusive && (check[i] < ll[i] || check[i] > ur[i]) || !inclusive && (check[i] <= ll[i] || check[i] >= ur[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static Pair<PointValue, PointValue> boundingBoxOf(double minLon, double maxLon, double minLat, double maxLat, PointValue center, double distance) {
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            int dimension = center.getCoordinateReferenceSystem().getDimension();
            double[] min = new double[dimension];
            double[] max = new double[dimension];
            min[0] = minLon;
            min[1] = minLat;
            max[0] = maxLon;
            max[1] = maxLat;
            if (dimension > 2) {
                double[] coordinates = center.coordinate();
                for (int i = 2; i < dimension; ++i) {
                    min[i] = coordinates[i] - distance;
                    max[i] = coordinates[i] + distance;
                }
            }
            return Pair.of((Object)Values.pointValue(crs, min), (Object)Values.pointValue(crs, max));
        }

        private PointValue withLongitude(double longitude, PointValue point) {
            double[] coordinates = Arrays.copyOf(point.coordinate(), point.coordinate().length);
            coordinates[0] = longitude;
            return Values.pointValue(point.getCoordinateReferenceSystem(), coordinates);
        }

        private boolean isNorthOf(double[] p1, double[] p2) {
            return p1[1] > p2[1];
        }
    }

    public static class CartesianCalculator
    extends CRSCalculator {
        int dimension;

        CartesianCalculator(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public double distance(PointValue p1, PointValue p2) {
            assert (p1.getCoordinateReferenceSystem().getDimension() == this.dimension);
            assert (p2.getCoordinateReferenceSystem().getDimension() == this.dimension);
            return CartesianCalculator.pythagoras(p1.coordinate(), p2.coordinate());
        }

        @Override
        public List<Pair<PointValue, PointValue>> boundingBox(PointValue center, double distance) {
            assert (center.getCoordinateReferenceSystem().getDimension() == this.dimension);
            double[] coordinates = center.coordinate();
            double[] min = new double[this.dimension];
            double[] max = new double[this.dimension];
            for (int i = 0; i < this.dimension; ++i) {
                min[i] = coordinates[i] - distance;
                max[i] = coordinates[i] + distance;
            }
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            return Collections.singletonList(Pair.of((Object)Values.pointValue(crs, min), (Object)Values.pointValue(crs, max)));
        }

        @Override
        public boolean withinBBox(PointValue point, PointValue lowerLeft, PointValue upperRight, boolean inclusive) {
            if (lowerLeft == null && upperRight == null) {
                return true;
            }
            double[] check = point.coordinate();
            if (upperRight == null) {
                double[] ll = lowerLeft.coordinate();
                for (int i = 0; i < check.length; ++i) {
                    if (!(inclusive && check[i] < ll[i]) && (inclusive || !(check[i] <= ll[i]))) continue;
                    return false;
                }
                return true;
            }
            if (lowerLeft == null) {
                double[] ur = upperRight.coordinate();
                for (int i = 0; i < check.length; ++i) {
                    if (!(inclusive && check[i] > ur[i]) && (inclusive || !(check[i] >= ur[i]))) continue;
                    return false;
                }
                return true;
            }
            double[] ll = lowerLeft.coordinate();
            double[] ur = upperRight.coordinate();
            for (int i = 0; i < check.length; ++i) {
                if ((!inclusive || !(check[i] < ll[i]) && !(check[i] > ur[i])) && (inclusive || !(check[i] <= ll[i]) && !(check[i] >= ur[i]))) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<Pair<PointValue, PointValue>> computeBBoxes(PointValue lowerLeft, PointValue upperRight) {
            return List.of(Pair.of((Object)lowerLeft, (Object)upperRight));
        }
    }
}

