/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Objects;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.values.storable.CRSCalculator;
import org.neo4j.values.storable.CRSTable;

public enum CoordinateReferenceSystem implements CRS
{
    CARTESIAN(CRSTable.SR_ORG, 7203, 2, false),
    CARTESIAN_3D(CRSTable.SR_ORG, 9157, 3, false),
    WGS_84(CRSTable.EPSG, 4326, 2, true),
    WGS_84_3D(CRSTable.EPSG, 4979, 3, true);

    private static final CoordinateReferenceSystem[] COORDINATE_REFERENCE_SYSTEMS;
    private final String name = this.name().toLowerCase().replace('_', '-');
    private final CRSTable table;
    private final int code;
    private final String href;
    private final int dimension;
    private final boolean geographic;
    private final CRSCalculator calculator;

    public static Iterable<CoordinateReferenceSystem> all() {
        return Iterables.asIterable((Object[])COORDINATE_REFERENCE_SYSTEMS);
    }

    public static CoordinateReferenceSystem get(int tableId, int code) {
        CRSTable table = CRSTable.find(tableId);
        for (CoordinateReferenceSystem crs : COORDINATE_REFERENCE_SYSTEMS) {
            if (crs.table != table || crs.code != code) continue;
            return crs;
        }
        throw new InvalidArgumentException("Unknown coordinate reference system: " + tableId + "-" + code);
    }

    public static CoordinateReferenceSystem get(CRS crs) {
        Objects.requireNonNull(crs);
        return CoordinateReferenceSystem.get(crs.getHref());
    }

    public static CoordinateReferenceSystem byName(String name) {
        for (CoordinateReferenceSystem crs : COORDINATE_REFERENCE_SYSTEMS) {
            if (!crs.name.equals(name.toLowerCase())) continue;
            return crs;
        }
        throw new InvalidArgumentException("Unknown coordinate reference system: " + name);
    }

    public static CoordinateReferenceSystem get(String href) {
        for (CoordinateReferenceSystem crs : COORDINATE_REFERENCE_SYSTEMS) {
            if (!crs.href.equals(href)) continue;
            return crs;
        }
        throw new InvalidArgumentException("Unknown coordinate reference system: " + href);
    }

    public static CoordinateReferenceSystem get(int code) {
        for (CRSTable table : CRSTable.TYPES) {
            String href = table.href(code);
            for (CoordinateReferenceSystem crs : COORDINATE_REFERENCE_SYSTEMS) {
                if (!crs.href.equals(href)) continue;
                return crs;
            }
        }
        throw new InvalidArgumentException("Unknown coordinate reference system code: " + code);
    }

    private CoordinateReferenceSystem(CRSTable table, int code, int dimension, boolean geographic) {
        this.table = table;
        this.code = code;
        this.href = table.href(code);
        this.dimension = dimension;
        this.geographic = geographic;
        this.calculator = geographic ? new CRSCalculator.GeographicCalculator(dimension) : new CRSCalculator.CartesianCalculator(dimension);
    }

    public String toString() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.name;
    }

    public String getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public CRSTable getTable() {
        return this.table;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isGeographic() {
        return this.geographic;
    }

    public CRSCalculator getCalculator() {
        return this.calculator;
    }

    static {
        COORDINATE_REFERENCE_SYSTEMS = CoordinateReferenceSystem.values();
    }
}

