/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v50;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointLogEntrySerializerV5_0
extends LogEntrySerializer<LogEntryDetachedCheckpointV5_0> {
    public static final int RECORD_LENGTH_BYTES = 232;
    public static final int MAX_DESCRIPTION_LENGTH = 116;

    public DetachedCheckpointLogEntrySerializerV5_0() {
        super((byte)9);
    }

    @Override
    public LogEntryDetachedCheckpointV5_0 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long logVersion = channel.getLong();
        long byteOffset = channel.getLong();
        long checkpointTimeMillis = channel.getLong();
        byte[] storeIdBuffer = new byte[64];
        channel.get(storeIdBuffer, storeIdBuffer.length);
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        long txId = channel.getLong();
        TransactionId transactionId = new TransactionId(txId, txId, version, channel.getInt(), channel.getLong(), -1L);
        short reasonBytesLength = channel.getShort();
        byte[] bytes = new byte[116];
        channel.get(bytes, 116);
        String reason = new String(bytes, 0, (int)reasonBytesLength, StandardCharsets.UTF_8);
        channel.endChecksumAndValidate();
        return new LogEntryDetachedCheckpointV5_0(version, transactionId, new LogPosition(logVersion, byteOffset), checkpointTimeMillis, storeId, reason, false);
    }

    @Override
    public int write(WritableChannel channel, LogEntryDetachedCheckpointV5_0 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        DetachedCheckpointLogEntrySerializerV5_0.writeLogEntryHeader(logEntry.kernelVersion(), (byte)9, channel);
        byte[] storeIdBuffer = new byte[64];
        StoreIdSerialization.serializeWithFixedSize((StoreId)logEntry.getStoreId(), (ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        byte[] reasonBytes = logEntry.getReason().getBytes();
        short length = Numbers.safeCastIntToShort((int)Math.min(reasonBytes.length, 116));
        byte[] descriptionBytes = new byte[116];
        System.arraycopy(reasonBytes, 0, descriptionBytes, 0, length);
        LogPosition logPosition = logEntry.getLogPosition();
        TransactionId transactionId = logEntry.getTransactionId();
        channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset()).putLong(logEntry.getCheckpointTime()).put(storeIdBuffer, storeIdBuffer.length).putLong(transactionId.id()).putInt(transactionId.checksum()).putLong(transactionId.commitTimestamp()).putShort(length).put(descriptionBytes, descriptionBytes.length);
        return channel.putChecksum();
    }
}

