/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v57;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class ChunkEndLogEntrySerializerV5_7
extends LogEntrySerializer<LogEntryChunkEnd> {
    public ChunkEndLogEntrySerializerV5_7() {
        super((byte)11);
    }

    @Override
    public LogEntryChunkEnd parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long txId = channel.getLong();
        long chunkId = channel.getLong();
        int checksum = channel.endChecksumAndValidate();
        return new LogEntryChunkEnd(version, txId, chunkId, checksum);
    }

    @Override
    public int write(WritableChannel channel, LogEntryChunkEnd logEntry) throws IOException {
        ChunkEndLogEntrySerializerV5_7.writeLogEntryHeader(logEntry.kernelVersion(), (byte)11, channel);
        channel.putLong(logEntry.getTransactionId());
        channel.putLong(logEntry.getChunkId());
        return channel.putChecksum();
    }
}

