/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.zip.Checksum;
import org.neo4j.io.fs.PhysicalLogChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogTracers;
import org.neo4j.kernel.impl.transaction.log.entry.LogEnvelopeHeader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class EnvelopeWriteChannel
implements PhysicalLogChannel {
    @VisibleForTesting
    static final String ERROR_MSG_TEMPLATE_OFFSET_SIZE_TOO_SMALL = "offset size (%d) must be at least envelope header size (%d).";
    @VisibleForTesting
    static final String ERROR_MSG_TEMPLATE_OFFSET_SIZE_TOO_LARGE = "offset size (%d) cannot be bigger than the segment size (%d) and must leave enough space for at least one envelope after it.";
    @VisibleForTesting
    static final String ERROR_MSG_TEMPLATE_OFFSET_MUST_BE_FIRST_IN_THE_FIRST_SEGMENT = "START_OFFSET envelopes can only be inserted at the start of the first segment";
    @VisibleForTesting
    static final String ERROR_MSG_TEMPLATE_OFFSET_MUST_NOT_BE_INSIDE_ANOTHER_ENVELOPE = "START_OFFSET cannot be inserted while another envelope is still open. Close the current entry first.";
    @VisibleForTesting
    static final String ERROR_MSG_TEMPLATE_OFFSET_NOT_CONSISTENT = "The provided offset is aligned on a segment, but the existing channel is at a different offset";
    private static final byte[] PADDING_ZEROES = new byte[39];
    private final Checksum checksum = (Checksum)CHECKSUM_FACTORY.get();
    private final ScopedBuffer scopedBuffer;
    private final LogRotation logRotation;
    private final LogTracers logTracers;
    private final ByteBuffer buffer;
    private final ByteBuffer checksumView;
    private final int segmentBlockSize;
    private StoreChannel channel;
    private int currentEnvelopeStart;
    private byte currentVersion = (byte)-1;
    private byte currentContentType = (byte)-1;
    private long currentIndex;
    private long currentTerm = -1L;
    private int lastWrittenPosition;
    private boolean begin = true;
    private int nextSegmentOffset;
    private int previousChecksum;
    private long rotateAtSize;
    private long appendedBytes;
    private volatile boolean closed;

    public EnvelopeWriteChannel(StoreChannel channel, ScopedBuffer scopedBuffer, int segmentBlockSize, int initialChecksum, long currentIndex, LogTracers logTracers, LogRotation logRotation) throws IOException {
        this.channel = Objects.requireNonNull(channel);
        this.scopedBuffer = Objects.requireNonNull(scopedBuffer);
        this.previousChecksum = initialChecksum;
        Preconditions.requirePowerOfTwo((long)segmentBlockSize);
        this.segmentBlockSize = segmentBlockSize;
        this.logRotation = Objects.requireNonNull(logRotation);
        this.logTracers = Objects.requireNonNull(logTracers);
        this.buffer = scopedBuffer.getBuffer();
        this.checksumView = this.buffer.duplicate().order(this.buffer.order());
        this.currentIndex = currentIndex;
        Preconditions.requireMultipleOf((String)"Buffer", (long)this.buffer.capacity(), (String)"segment block size", (long)segmentBlockSize);
        this.initialPositions(channel.position());
    }

    private static LogEnvelopeHeader.EnvelopeType completedEnvelopeType(boolean begin, boolean end) {
        if (begin && end) {
            return LogEnvelopeHeader.EnvelopeType.FULL;
        }
        if (begin) {
            return LogEnvelopeHeader.EnvelopeType.BEGIN;
        }
        if (end) {
            return LogEnvelopeHeader.EnvelopeType.END;
        }
        return LogEnvelopeHeader.EnvelopeType.MIDDLE;
    }

    public int currentChecksum() {
        return this.previousChecksum;
    }

    public void endCurrentEntry() {
        Preconditions.checkState((this.currentPayloadLength() > 0 ? 1 : 0) != 0, (String)"Closing empty envelope is not allowed.");
        this.completeEnvelope(true);
        this.currentContentType = (byte)-1;
    }

    public void prepareNextEnvelope() throws IOException {
        if (this.buffer.position() + 31 >= this.nextSegmentOffset) {
            this.padSegmentAndGoToNext();
        }
        this.beginNewEnvelope();
    }

    public void resetAppendedBytesCounter() {
        this.appendedBytes = 0L;
    }

    public long getAppendedBytes() {
        return this.appendedBytes;
    }

    public void setChannel(StoreChannel channel) throws IOException {
        Preconditions.checkArgument((channel != this.channel ? 1 : 0) != 0, (String)"Must NOT update the channel to the same instance otherwise we're overwriting data!");
        this.channel = channel;
        Preconditions.checkState((channel.position() == (long)this.segmentBlockSize ? 1 : 0) != 0, (String)"must be positioned on first segment");
        this.initialPositions(this.segmentBlockSize);
    }

    public long position() throws IOException {
        Preconditions.checkState((this.buffer.position() == this.currentEnvelopeStart ? 1 : 0) != 0, (String)"position() must be called right after endCurrentEntry()");
        long bufferViewStart = this.channel.position() - (long)this.lastWrittenPosition;
        return bufferViewStart + (long)this.currentEnvelopeStart;
    }

    public void beginChecksumForWriting() throws IOException {
        this.prepareNextEnvelope();
    }

    public Flushable prepareForFlush() throws IOException {
        this.checkChannelClosed(null);
        if (this.lastWrittenPosition == this.currentEnvelopeStart) {
            return this.channel;
        }
        int oldPosition = this.buffer.position();
        this.buffer.position(this.lastWrittenPosition).limit(this.currentEnvelopeStart);
        try {
            this.channel.writeAll(this.buffer);
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
        this.buffer.clear().position(oldPosition);
        this.lastWrittenPosition = this.currentEnvelopeStart;
        if (this.currentEnvelopeStart >= this.buffer.capacity()) {
            this.buffer.clear();
            this.lastWrittenPosition = 0;
            this.currentEnvelopeStart = 0;
            this.nextSegmentOffset = 0;
        }
        return this.channel;
    }

    public EnvelopeWriteChannel put(byte value) throws IOException {
        this.nextSegmentOnOverflow(1);
        this.buffer.put(value);
        return this.updateBytesWritten(1);
    }

    public EnvelopeWriteChannel putShort(short value) throws IOException {
        this.nextSegmentOnOverflow(2);
        this.buffer.putShort(value);
        return this.updateBytesWritten(2);
    }

    public EnvelopeWriteChannel putInt(int value) throws IOException {
        this.nextSegmentOnOverflow(4);
        this.buffer.putInt(value);
        return this.updateBytesWritten(4);
    }

    public EnvelopeWriteChannel putLong(long value) throws IOException {
        this.nextSegmentOnOverflow(8);
        this.buffer.putLong(value);
        return this.updateBytesWritten(8);
    }

    public EnvelopeWriteChannel putFloat(float value) throws IOException {
        this.nextSegmentOnOverflow(4);
        this.buffer.putFloat(value);
        return this.updateBytesWritten(4);
    }

    public EnvelopeWriteChannel putDouble(double value) throws IOException {
        this.nextSegmentOnOverflow(8);
        this.buffer.putDouble(value);
        return this.updateBytesWritten(8);
    }

    public EnvelopeWriteChannel put(byte[] value, int length) throws IOException {
        return this.put(value, 0, length);
    }

    public EnvelopeWriteChannel put(byte[] src, int offset, int length) throws IOException {
        int srcIndex = offset;
        while (srcIndex < length) {
            int remainingPayloadSpace = this.nextSegmentOffset - this.buffer.position();
            int payloadChunk = Math.min(length - srcIndex, remainingPayloadSpace);
            this.buffer.put(src, srcIndex, payloadChunk);
            if ((srcIndex += payloadChunk) == length) continue;
            this.completeEnvelopeAndGoToNextSegment();
        }
        this.appendedBytes += (long)length;
        return this;
    }

    public EnvelopeWriteChannel putAll(ByteBuffer src) throws IOException {
        int length = src.remaining();
        int srcIndex = src.position();
        int srcLimit = src.limit();
        while (srcIndex < srcLimit) {
            int remainingPayloadSpace = this.nextSegmentOffset - this.buffer.position();
            int payloadChunk = Math.min(srcLimit - srcIndex, remainingPayloadSpace);
            this.buffer.put(this.buffer.position(), src, srcIndex, payloadChunk);
            this.buffer.position(this.buffer.position() + payloadChunk);
            if ((srcIndex += payloadChunk) == srcLimit) continue;
            this.completeEnvelopeAndGoToNextSegment();
        }
        this.appendedBytes += (long)length;
        return this;
    }

    public PhysicalLogChannel directPutAll(ByteBuffer src, long offset) throws IOException {
        if (offset != -1L) {
            int offsetIntoSegment = (int)(offset & (long)(this.segmentBlockSize - 1));
            if (offsetIntoSegment != 0 && this.currentEnvelopeStart % this.segmentBlockSize != offsetIntoSegment) {
                this.insertStartOffset(offsetIntoSegment);
            }
            if (offsetIntoSegment == 0) {
                int currentStartOffsetIntoSegment = this.currentEnvelopeStart % this.segmentBlockSize;
                if (currentStartOffsetIntoSegment >= this.segmentBlockSize - 31) {
                    this.padSegmentAndGoToNext(false);
                } else if (currentStartOffsetIntoSegment != 0) {
                    throw new IllegalStateException(ERROR_MSG_TEMPLATE_OFFSET_NOT_CONSISTENT);
                }
            }
        }
        int length = src.remaining();
        int srcIndex = src.position();
        int srcEnd = srcIndex + length;
        while (srcIndex < srcEnd) {
            int remainingPayloadSpace = this.nextSegmentOffset - this.buffer.position();
            int payloadChunk = Math.min(srcEnd - srcIndex, remainingPayloadSpace);
            this.buffer.put(this.buffer.position(), src, srcIndex, payloadChunk);
            this.buffer.position(this.buffer.position() + payloadChunk);
            if ((srcIndex += payloadChunk) == srcEnd) continue;
            this.padSegmentAndGoToNext(false);
        }
        this.appendedBytes += (long)length;
        this.currentEnvelopeStart = this.buffer.position();
        return this;
    }

    public boolean handlesRotationInternally() {
        return true;
    }

    public void putTerm(long term) {
        Preconditions.checkState((this.currentTerm <= term ? 1 : 0) != 0, (String)"Failed to write entry to replication log, the entry's term was less than the last appended term, terms must be monotonically increasing. [lastTermAppended=%d, entryTerm=%d]", (Object[])new Object[]{this.currentTerm, term});
        this.currentTerm = term;
    }

    public EnvelopeWriteChannel putContentType(byte contentType) {
        assert (contentType >= 0);
        this.currentContentType = contentType;
        return this;
    }

    public WritableChannel putAppendIndex(long appendIndex) {
        if (appendIndex != this.currentIndex + (long)(this.begin ? 1 : 0)) {
            throw new IllegalStateException("Append index %s should be the same as current index %s".formatted(appendIndex, this.currentIndex + (long)(this.begin ? 1 : 0)));
        }
        return this;
    }

    public EnvelopeWriteChannel putVersion(byte version) {
        this.currentVersion = version;
        return this;
    }

    public int putChecksum() throws IOException {
        this.endCurrentEntry();
        return this.previousChecksum;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void truncateToPosition(long position, int previousChecksum, long previousIndex, long previousTerm) throws IOException {
        Preconditions.requireNonNegative((long)position);
        Preconditions.checkArgument((position <= this.channel.position() ? 1 : 0) != 0, (String)"Can only truncate written data.");
        Preconditions.checkArgument((position >= (long)this.segmentBlockSize ? 1 : 0) != 0, (String)"Truncating the first segment is not possible");
        this.previousChecksum = previousChecksum;
        this.currentIndex = previousIndex;
        this.currentTerm = previousTerm;
        this.channel.truncate(position);
        this.rotateLogFile();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.prepareForFlush().flush();
            this.closed = true;
            this.channel.close();
            this.scopedBuffer.close();
        }
    }

    private void initialPositions(long initialPosition) throws IOException {
        int bufferWindowOffset;
        this.currentEnvelopeStart = bufferWindowOffset = (int)(initialPosition % (long)this.buffer.capacity());
        this.lastWrittenPosition = bufferWindowOffset;
        this.nextSegmentOffset = (bufferWindowOffset / this.segmentBlockSize + 1) * this.segmentBlockSize;
        this.rotateAtSize = this.logRotation.rotationSize();
        Preconditions.requireMultipleOf((String)"Rotation size", (long)this.rotateAtSize, (String)"segment size", (long)this.segmentBlockSize);
        if (this.rotateAtSize == 0L) {
            this.rotateAtSize = Long.MAX_VALUE;
        }
        this.buffer.clear().position(bufferWindowOffset);
        long channelPos = this.channel.position();
        if (channelPos >= this.rotateAtSize && this.currentEnvelopeStart == this.nextSegmentOffset - this.segmentBlockSize) {
            this.nextSegmentOffset = this.currentEnvelopeStart;
        }
    }

    private void completeEnvelopeAndGoToNextSegment() throws IOException {
        this.completeEnvelope(false);
        this.padSegmentAndGoToNext();
        this.beginNewEnvelope();
    }

    private void completeEnvelope(boolean end) {
        LogEnvelopeHeader.EnvelopeType type = EnvelopeWriteChannel.completedEnvelopeType(this.begin, end);
        int payLoadLength = this.currentPayloadLength();
        if (payLoadLength == 0) {
            Preconditions.checkState((this.nextSegmentOffset - this.currentEnvelopeStart <= 39 ? 1 : 0) != 0, (String)"Empty envelopes can only be discarded at the end of the segment.");
            this.buffer.position(this.currentEnvelopeStart);
            return;
        }
        this.writeHeader(type, payLoadLength);
        this.begin = end;
    }

    private void writeHeader(LogEnvelopeHeader.EnvelopeType type, int payloadLength) {
        int payloadEndOffset = this.buffer.position();
        if (this.begin && type != LogEnvelopeHeader.EnvelopeType.START_OFFSET) {
            ++this.currentIndex;
        }
        int checksumStartOffset = this.currentEnvelopeStart + 4;
        this.buffer.position(checksumStartOffset);
        if (type == LogEnvelopeHeader.EnvelopeType.START_OFFSET) {
            this.buffer.put(type.typeValue).putInt(payloadLength).putLong(0L).put((byte)-1).putInt(0).putLong(-1L).put((byte)-1);
            int thisEnvelopeChecksum = this.calculateChecksum(payloadEndOffset, checksumStartOffset);
            this.buffer.putInt(this.currentEnvelopeStart, thisEnvelopeChecksum);
        } else {
            assert (this.currentVersion != -1);
            assert (this.currentContentType != -1);
            this.buffer.put(type.typeValue).putInt(payloadLength).putLong(this.currentIndex).put(this.currentVersion).putInt(this.previousChecksum).putLong(this.currentTerm).put(this.currentContentType);
            int thisEnvelopeChecksum = this.calculateChecksum(payloadEndOffset, checksumStartOffset);
            this.buffer.putInt(this.currentEnvelopeStart, thisEnvelopeChecksum);
            this.previousChecksum = thisEnvelopeChecksum;
        }
        this.buffer.position(payloadEndOffset);
        this.currentEnvelopeStart = payloadEndOffset;
    }

    private int calculateChecksum(int payloadEndOffset, int checksumStartOffset) {
        this.checksum.reset();
        this.checksum.update(this.checksumView.clear().limit(payloadEndOffset).position(checksumStartOffset));
        return (int)this.checksum.getValue();
    }

    private EnvelopeWriteChannel updateBytesWritten(int count) {
        this.appendedBytes += (long)count;
        return this;
    }

    private void nextSegmentOnOverflow(int spaceInBytes) throws IOException {
        if (this.buffer.position() + spaceInBytes > this.nextSegmentOffset) {
            this.completeEnvelopeAndGoToNextSegment();
        }
    }

    private void rotateIfLimitReached() throws IOException {
        if (this.channel.position() >= this.rotateAtSize) {
            this.rotateLogFile();
        }
    }

    private void beginNewEnvelope() {
        this.currentEnvelopeStart = this.buffer.position();
        this.buffer.position(this.currentEnvelopeStart + 31);
        this.appendedBytes += 31L;
    }

    private void padSegmentAndGoToNext() throws IOException {
        this.padSegmentAndGoToNext(true);
    }

    private void padSegmentAndGoToNext(boolean allowRotation) throws IOException {
        int position = this.buffer.position();
        if (position < this.nextSegmentOffset) {
            this.buffer.put(PADDING_ZEROES, 0, this.nextSegmentOffset - position);
            this.appendedBytes += (long)(this.nextSegmentOffset - position);
        }
        assert (this.buffer.position() == this.nextSegmentOffset);
        this.currentEnvelopeStart = this.nextSegmentOffset;
        if (this.currentEnvelopeStart == this.buffer.capacity() || this.channel.position() + (long)this.currentEnvelopeStart - (long)this.lastWrittenPosition >= this.rotateAtSize) {
            this.prepareForFlush();
        }
        this.nextSegmentOffset += this.segmentBlockSize;
        if (allowRotation) {
            this.rotateIfLimitReached();
        }
    }

    private void rotateLogFile() throws IOException {
        try (LogAppendEvent logAppendEvent = this.logTracers.logAppend();){
            this.logRotation.rotateLogFile(logAppendEvent, this.currentIndex, this.previousChecksum);
            logAppendEvent.setLogRotated(true);
        }
    }

    private void handleClosedChannelException(ClosedChannelException e) throws ClosedChannelException {
        this.checkChannelClosed(e);
        throw e;
    }

    private void checkChannelClosed(ClosedChannelException e) throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("This log channel has been closed", e);
        }
    }

    public int write(ByteBuffer src) throws IOException {
        int remaining = src.remaining();
        this.putAll(src);
        return remaining;
    }

    private int currentPayloadLength() {
        return this.buffer.position() - (this.currentEnvelopeStart + 31);
    }

    public void insertStartOffset(int size) throws IOException {
        Preconditions.checkArgument((size > 31 ? 1 : 0) != 0, (String)ERROR_MSG_TEMPLATE_OFFSET_SIZE_TOO_SMALL, (Object[])new Object[]{size, 31});
        Preconditions.checkArgument((size < this.segmentBlockSize - 31 ? 1 : 0) != 0, (String)ERROR_MSG_TEMPLATE_OFFSET_SIZE_TOO_LARGE, (Object[])new Object[]{size, this.segmentBlockSize});
        Preconditions.checkState(((this.currentEnvelopeStart == 0 || this.currentEnvelopeStart == this.segmentBlockSize) && this.channel.position() == (long)this.segmentBlockSize ? 1 : 0) != 0, (String)ERROR_MSG_TEMPLATE_OFFSET_MUST_BE_FIRST_IN_THE_FIRST_SEGMENT);
        Preconditions.checkState((this.currentEnvelopeStart == this.buffer.position() ? 1 : 0) != 0, (String)ERROR_MSG_TEMPLATE_OFFSET_MUST_NOT_BE_INSIDE_ANOTHER_ENVELOPE);
        int payloadLength = size - 31;
        this.buffer.position(this.currentEnvelopeStart + 31);
        this.put(new byte[payloadLength], payloadLength);
        this.writeHeader(LogEnvelopeHeader.EnvelopeType.START_OFFSET, payloadLength);
    }

    public long currentIndex() {
        return this.currentIndex;
    }

    public long currentTerm() {
        return this.currentTerm;
    }
}

