/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;

public class LogBinarySearch {
    public static long binarySearch(BinarySearchReader reader, long target) throws IOException {
        int size = reader.size();
        if (size <= 0) {
            throw new IllegalStateException("Reader must have at least one searchable element");
        }
        int low = 0;
        int high = size - 1;
        int lowerResultIndex = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midValue = reader.get(mid);
            int cmp = reader.compare(midValue, target);
            if (cmp < 0) {
                lowerResultIndex = mid;
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midValue;
        }
        if (lowerResultIndex == -1) {
            return -1L;
        }
        return reader.get(lowerResultIndex);
    }

    public static interface BinarySearchReader {
        public int size();

        public long get(int var1);

        public int compare(long var1, long var3);
    }
}

