/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

public enum LogEntryParsersV4_0 implements LogEntryParser
{
    TX_START{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            LogPosition position = marker.newPosition();
            long timeWritten = channel.getLong();
            long latestCommittedTxWhenStarted = channel.getLong();
            int previousChecksum = channel.getInt();
            int additionalHeaderLength = channel.getInt();
            byte[] additionalHeader = new byte[additionalHeaderLength];
            channel.get(additionalHeader, additionalHeaderLength);
            return new LogEntryStart(version, timeWritten, latestCommittedTxWhenStarted, previousChecksum, additionalHeader, position);
        }

        @Override
        public byte byteCode() {
            return 1;
        }
    }
    ,
    COMMAND{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            StorageCommand command = commandReader.get((int)version.version()).read((ReadableChannel)channel);
            return command == null ? null : new LogEntryCommand(version, command);
        }

        @Override
        public byte byteCode() {
            return 3;
        }
    }
    ,
    TX_COMMIT{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            long txId = channel.getLong();
            long timeWritten = channel.getLong();
            int checksum = channel.endChecksumAndValidate();
            return new LogEntryCommit(version, txId, timeWritten, checksum);
        }

        @Override
        public byte byteCode() {
            return 5;
        }
    }
    ,
    CHECK_POINT{

        @Override
        public LogEntry parse(LogEntryVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReader) throws IOException {
            long logVersion = channel.getLong();
            long byteOffset = channel.getLong();
            channel.endChecksumAndValidate();
            return new CheckPoint(version, new LogPosition(logVersion, byteOffset));
        }

        @Override
        public byte byteCode() {
            return 7;
        }
    };

}

